/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.variable.EntityManagerSession;
import org.camunda.bpm.engine.impl.variable.JPAEntityMappings;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;

public class JPAEntityVariableType
implements VariableType {
    public static final String TYPE_NAME = "jpa-entity";
    private JPAEntityMappings mappings = new JPAEntityMappings();

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isCachable() {
        return false;
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return this.mappings.isJPAEntity(value);
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        EntityManagerSession entityManagerSession = Context.getCommandContext().getSession(EntityManagerSession.class);
        if (entityManagerSession == null) {
            throw new ProcessEngineException("Cannot set JPA variable: " + EntityManagerSession.class + " not configured");
        }
        entityManagerSession.flush();
        if (value != null) {
            String className = this.mappings.getJPAClassString(value);
            String idString = this.mappings.getJPAIdString(value);
            valueFields.setTextValue(className);
            valueFields.setTextValue2(idString);
        } else {
            valueFields.setTextValue(null);
            valueFields.setTextValue2(null);
        }
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getTextValue() != null && valueFields.getTextValue2() != null) {
            return this.mappings.getJPAEntity(valueFields.getTextValue(), valueFields.getTextValue2());
        }
        return null;
    }

    @Override
    public String getTypeNameForValue(Object value) {
        if (value != null) {
            return value.getClass().getSimpleName();
        }
        return TYPE_NAME;
    }
}

