/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.util.EngineUtilLogger;

public class IoUtil {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;

    public static byte[] readInputStream(InputStream inputStream, String inputStreamName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try {
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        catch (Exception e) {
            throw LOG.exceptionWhileReadingStream(inputStreamName, e);
        }
        return outputStream.toByteArray();
    }

    public static String readFileAsString(String filePath) {
        byte[] buffer = new byte[(int)IoUtil.getFile(filePath).length()];
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(IoUtil.getFile(filePath)));
            inputStream.read(buffer);
        }
        catch (Exception e) {
            try {
                throw LOG.exceptionWhileReadingFile(filePath, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(inputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(inputStream);
        return new String(buffer, Charset.forName("UTF-8"));
    }

    public static File getFile(String filePath) {
        URL url = IoUtil.class.getClassLoader().getResource(filePath);
        try {
            return new File(url.toURI());
        }
        catch (Exception e) {
            throw LOG.exceptionWhileGettingFile(filePath, e);
        }
    }

    public static void writeStringToFile(String content, String filePath) {
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(IoUtil.getFile(filePath)));
            outputStream.write(content.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                throw LOG.exceptionWhileWritingToFile(filePath, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(outputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(outputStream);
    }

    public static void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ignore) {
            LOG.debugCloseException(ignore);
        }
    }

    public static void flushSilently(Flushable flushable) {
        try {
            if (flushable != null) {
                flushable.flush();
            }
        }
        catch (IOException ignore) {
            LOG.debugCloseException(ignore);
        }
    }
}

