/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.ExternalTaskQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.cmd.UpdateExternalTaskRetriesBuilderImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractSetExternalTaskRetriesCmd<T>
implements Command<T> {
    protected UpdateExternalTaskRetriesBuilderImpl builder;

    public AbstractSetExternalTaskRetriesCmd(UpdateExternalTaskRetriesBuilderImpl builder) {
        this.builder = builder;
    }

    protected List<String> collectProcessInstanceIds() {
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery;
        ProcessInstanceQueryImpl processInstanceQuery;
        HashSet<String> collectedProcessInstanceIds = new HashSet<String>();
        List<String> processInstanceIds = this.builder.getProcessInstanceIds();
        if (processInstanceIds != null && !processInstanceIds.isEmpty()) {
            collectedProcessInstanceIds.addAll(processInstanceIds);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.builder.getProcessInstanceQuery()) != null) {
            collectedProcessInstanceIds.addAll(processInstanceQuery.listIds());
        }
        if ((historicProcessInstanceQuery = (HistoricProcessInstanceQueryImpl)this.builder.getHistoricProcessInstanceQuery()) != null) {
            collectedProcessInstanceIds.addAll(historicProcessInstanceQuery.listIds());
        }
        return new ArrayList<String>(collectedProcessInstanceIds);
    }

    protected List<String> collectExternalTaskIds() {
        List<String> collectedProcessInstanceIds;
        ExternalTaskQueryImpl externalTaskQuery;
        final HashSet<String> collectedIds = new HashSet<String>();
        List<String> externalTaskIds = this.builder.getExternalTaskIds();
        if (externalTaskIds != null) {
            EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "External task id cannot be null", "externalTaskIds", externalTaskIds);
            collectedIds.addAll(externalTaskIds);
        }
        if ((externalTaskQuery = (ExternalTaskQueryImpl)this.builder.getExternalTaskQuery()) != null) {
            collectedIds.addAll(externalTaskQuery.listIds());
        }
        if (!(collectedProcessInstanceIds = this.collectProcessInstanceIds()).isEmpty()) {
            Context.getCommandContext().runWithoutAuthorization(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ExternalTaskQueryImpl query = new ExternalTaskQueryImpl();
                    query.processInstanceIdIn(collectedProcessInstanceIds.toArray(new String[collectedProcessInstanceIds.size()]));
                    collectedIds.addAll(query.listIds());
                    return null;
                }
            });
        }
        return new ArrayList<String>(collectedIds);
    }

    protected void writeUserOperationLog(CommandContext commandContext, int retries, int numInstances, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        propertyChanges.add(new PropertyChange("retries", null, retries));
        commandContext.getOperationLogManager().logExternalTaskOperation("SetExternalTaskRetries", null, propertyChanges);
    }
}

