/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.sql;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSession;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;

public class DbSqlSessionFactory
implements SessionFactory {
    public static final String MSSQL = "mssql";
    public static final String DB2 = "db2";
    public static final String ORACLE = "oracle";
    public static final String H2 = "h2";
    public static final String MYSQL = "mysql";
    public static final String POSTGRES = "postgres";
    public static final String MARIADB = "mariadb";
    public static final String[] SUPPORTED_DATABASES = new String[]{"mssql", "db2", "oracle", "h2", "mysql", "postgres", "mariadb"};
    protected static final Map<String, Map<String, String>> databaseSpecificStatements = new HashMap<String, Map<String, String>>();
    public static final Map<String, String> databaseSpecificLimitBeforeStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitAfterStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBeforeWithoutOffsetStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitAfterWithoutOffsetStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificInnerLimitAfterStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBetweenStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBetweenFilterStatements = new HashMap<String, String>();
    public static final Map<String, String> optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements = new HashMap<String, String>();
    public static final Map<String, String> optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificEscapeChar = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificOrderByStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificLimitBeforeNativeQueryStatements = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificBitAnd1 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificBitAnd2 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificBitAnd3 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDatepart1 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDatepart2 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDatepart3 = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDummyTable = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificIfNull = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificTrueConstant = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificFalseConstant = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificDistinct = new HashMap<String, String>();
    public static final Map<String, Map<String, String>> dbSpecificConstants = new HashMap<String, Map<String, String>>();
    public static final Map<String, String> databaseSpecificDaysComparator = new HashMap<String, String>();
    public static final Map<String, String> databaseSpecificCollationForCaseSensitivity = new HashMap<String, String>();
    protected String databaseType;
    protected String databaseTablePrefix = "";
    protected String databaseSchema;
    protected SqlSessionFactory sqlSessionFactory;
    protected IdGenerator idGenerator;
    protected Map<String, String> statementMappings;
    protected Map<Class<?>, String> insertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> updateStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> deleteStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> selectStatements = new ConcurrentHashMap();
    protected boolean isDbIdentityUsed = true;
    protected boolean isDbHistoryUsed = true;
    protected boolean cmmnEnabled = true;
    protected boolean dmnEnabled = true;

    @Override
    public Class<?> getSessionType() {
        return DbSqlSession.class;
    }

    @Override
    public Session openSession() {
        return new DbSqlSession(this);
    }

    public String getInsertStatement(DbEntity object) {
        return this.getStatement(object.getClass(), this.insertStatements, "insert");
    }

    public String getUpdateStatement(DbEntity object) {
        return this.getStatement(object.getClass(), this.updateStatements, "update");
    }

    public String getDeleteStatement(Class<?> persistentObjectClass) {
        return this.getStatement(persistentObjectClass, this.deleteStatements, "delete");
    }

    public String getSelectStatement(Class<?> persistentObjectClass) {
        return this.getStatement(persistentObjectClass, this.selectStatements, "select");
    }

    private String getStatement(Class<?> persistentObjectClass, Map<Class<?>, String> cachedStatements, String prefix) {
        String statement = cachedStatements.get(persistentObjectClass);
        if (statement != null) {
            return statement;
        }
        statement = prefix + ClassNameUtil.getClassNameWithoutPackage(persistentObjectClass);
        statement = statement.substring(0, statement.length() - 6);
        cachedStatements.put(persistentObjectClass, statement);
        return statement;
    }

    protected static void addDatabaseSpecificStatement(String databaseType, String activitiStatement, String ibatisStatement) {
        Map<String, String> specificStatements = databaseSpecificStatements.get(databaseType);
        if (specificStatements == null) {
            specificStatements = new HashMap<String, String>();
            databaseSpecificStatements.put(databaseType, specificStatements);
        }
        specificStatements.put(activitiStatement, ibatisStatement);
    }

    public String mapStatement(String statement) {
        if (this.statementMappings == null) {
            return statement;
        }
        String mappedStatement = this.statementMappings.get(statement);
        return mappedStatement != null ? mappedStatement : statement;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        this.statementMappings = databaseSpecificStatements.get(databaseType);
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, String> getStatementMappings() {
        return this.statementMappings;
    }

    public void setStatementMappings(Map<String, String> statementMappings) {
        this.statementMappings = statementMappings;
    }

    public Map<Class<?>, String> getInsertStatements() {
        return this.insertStatements;
    }

    public void setInsertStatements(Map<Class<?>, String> insertStatements) {
        this.insertStatements = insertStatements;
    }

    public Map<Class<?>, String> getUpdateStatements() {
        return this.updateStatements;
    }

    public void setUpdateStatements(Map<Class<?>, String> updateStatements) {
        this.updateStatements = updateStatements;
    }

    public Map<Class<?>, String> getDeleteStatements() {
        return this.deleteStatements;
    }

    public void setDeleteStatements(Map<Class<?>, String> deleteStatements) {
        this.deleteStatements = deleteStatements;
    }

    public Map<Class<?>, String> getSelectStatements() {
        return this.selectStatements;
    }

    public void setSelectStatements(Map<Class<?>, String> selectStatements) {
        this.selectStatements = selectStatements;
    }

    public boolean isDbIdentityUsed() {
        return this.isDbIdentityUsed;
    }

    public void setDbIdentityUsed(boolean isDbIdentityUsed) {
        this.isDbIdentityUsed = isDbIdentityUsed;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public boolean isCmmnEnabled() {
        return this.cmmnEnabled;
    }

    public void setCmmnEnabled(boolean cmmnEnabled) {
        this.cmmnEnabled = cmmnEnabled;
    }

    public boolean isDmnEnabled() {
        return this.dmnEnabled;
    }

    public void setDmnEnabled(boolean dmnEnabled) {
        this.dmnEnabled = dmnEnabled;
    }

    public void setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    static {
        String defaultOrderBy = "order by ${internalOrderBy}";
        String defaultEscapeChar = "'\\'";
        databaseSpecificLimitBeforeStatements.put(H2, "");
        optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(H2, "");
        databaseSpecificLimitAfterStatements.put(H2, "LIMIT #{maxResults} OFFSET #{firstResult}");
        optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(H2, "LIMIT #{maxResults}");
        databaseSpecificLimitBeforeWithoutOffsetStatements.put(H2, "");
        databaseSpecificLimitAfterWithoutOffsetStatements.put(H2, "LIMIT #{maxResults}");
        databaseSpecificInnerLimitAfterStatements.put(H2, databaseSpecificLimitAfterStatements.get(H2));
        databaseSpecificLimitBetweenStatements.put(H2, "");
        databaseSpecificLimitBetweenFilterStatements.put(H2, "");
        databaseSpecificOrderByStatements.put(H2, defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put(H2, "");
        databaseSpecificDistinct.put(H2, "distinct");
        databaseSpecificEscapeChar.put(H2, defaultEscapeChar);
        databaseSpecificBitAnd1.put(H2, "BITAND(");
        databaseSpecificBitAnd2.put(H2, ",");
        databaseSpecificBitAnd3.put(H2, ")");
        databaseSpecificDatepart1.put(H2, "");
        databaseSpecificDatepart2.put(H2, "(");
        databaseSpecificDatepart3.put(H2, ")");
        databaseSpecificDummyTable.put(H2, "");
        databaseSpecificTrueConstant.put(H2, "1");
        databaseSpecificFalseConstant.put(H2, "0");
        databaseSpecificIfNull.put(H2, "IFNULL");
        databaseSpecificDaysComparator.put(H2, "DATEDIFF(DAY, ${date}, #{currentTimestamp}) >= ${days}");
        databaseSpecificCollationForCaseSensitivity.put(H2, "");
        HashMap<String, String> constants = new HashMap<String, String>();
        constants.put("constant.event", "'event'");
        constants.put("constant.op_message", "NEW_VALUE_ || '_|_' || PROPERTY_");
        constants.put("constant_for_update", "for update");
        constants.put("constant.datepart.quarter", "QUARTER");
        constants.put("constant.datepart.month", "MONTH");
        constants.put("constant.datepart.minute", "MINUTE");
        constants.put("constant.null.startTime", "null START_TIME_");
        constants.put("constant.varchar.cast", "'${key}'");
        constants.put("constant.integer.cast", "NULL");
        constants.put("constant.null.reporter", "NULL AS REPORTER_");
        dbSpecificConstants.put(H2, constants);
        for (String mysqlLikeDatabase : Arrays.asList(MYSQL, MARIADB)) {
            databaseSpecificLimitBeforeStatements.put(mysqlLikeDatabase, "");
            optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(mysqlLikeDatabase, "");
            databaseSpecificLimitAfterStatements.put(mysqlLikeDatabase, "LIMIT #{maxResults} OFFSET #{firstResult}");
            optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(mysqlLikeDatabase, "LIMIT #{maxResults}");
            databaseSpecificLimitBeforeWithoutOffsetStatements.put(mysqlLikeDatabase, "");
            databaseSpecificLimitAfterWithoutOffsetStatements.put(mysqlLikeDatabase, "LIMIT #{maxResults}");
            databaseSpecificInnerLimitAfterStatements.put(mysqlLikeDatabase, databaseSpecificLimitAfterStatements.get(mysqlLikeDatabase));
            databaseSpecificLimitBetweenStatements.put(mysqlLikeDatabase, "");
            databaseSpecificLimitBetweenFilterStatements.put(mysqlLikeDatabase, "");
            databaseSpecificOrderByStatements.put(mysqlLikeDatabase, defaultOrderBy);
            databaseSpecificLimitBeforeNativeQueryStatements.put(mysqlLikeDatabase, "");
            databaseSpecificDistinct.put(mysqlLikeDatabase, "distinct");
            databaseSpecificEscapeChar.put(mysqlLikeDatabase, "'\\\\'");
            databaseSpecificBitAnd1.put(mysqlLikeDatabase, "");
            databaseSpecificBitAnd2.put(mysqlLikeDatabase, " & ");
            databaseSpecificBitAnd3.put(mysqlLikeDatabase, "");
            databaseSpecificDatepart1.put(mysqlLikeDatabase, "");
            databaseSpecificDatepart2.put(mysqlLikeDatabase, "(");
            databaseSpecificDatepart3.put(mysqlLikeDatabase, ")");
            databaseSpecificDummyTable.put(mysqlLikeDatabase, "");
            databaseSpecificTrueConstant.put(mysqlLikeDatabase, "1");
            databaseSpecificFalseConstant.put(mysqlLikeDatabase, "0");
            databaseSpecificIfNull.put(mysqlLikeDatabase, "IFNULL");
            databaseSpecificDaysComparator.put(mysqlLikeDatabase, "DATEDIFF(#{currentTimestamp}, ${date}) >= ${days}");
            databaseSpecificCollationForCaseSensitivity.put(mysqlLikeDatabase, "");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "toggleForeignKey", "toggleForeignKey_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "selectProcessDefinitionsByQueryCriteria", "selectProcessDefinitionsByQueryCriteria_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "selectProcessDefinitionCountByQueryCriteria", "selectProcessDefinitionCountByQueryCriteria_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "selectDeploymentsByQueryCriteria", "selectDeploymentsByQueryCriteria_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "selectDeploymentCountByQueryCriteria", "selectDeploymentCountByQueryCriteria_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteExceptionByteArraysByIds", "deleteExceptionByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteErrorDetailsByteArraysByIds", "deleteErrorDetailsByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricDetailsByIds", "deleteHistoricDetailsByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricDetailByteArraysByIds", "deleteHistoricDetailByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricIdentityLinksByTaskProcessInstanceIds", "deleteHistoricIdentityLinksByTaskProcessInstanceIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricIdentityLinksByTaskCaseInstanceIds", "deleteHistoricIdentityLinksByTaskCaseInstanceIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricDecisionInputInstanceByteArraysByDecisionInstanceIds", "deleteHistoricDecisionInputInstanceByteArraysByDecisionInstanceIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricDecisionOutputInstanceByteArraysByDecisionInstanceIds", "deleteHistoricDecisionOutputInstanceByteArraysByDecisionInstanceIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricVariableInstanceByIds", "deleteHistoricVariableInstanceByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricVariableInstanceByteArraysByIds", "deleteHistoricVariableInstanceByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteCommentsByIds", "deleteCommentsByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteAttachmentByteArraysByIds", "deleteAttachmentByteArraysByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteAttachmentByIds", "deleteAttachmentByIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "deleteHistoricIncidentsByBatchIds", "deleteHistoricIncidentsByBatchIds_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateUserOperationLogByRootProcessInstanceId", "updateUserOperationLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateExternalTaskLogByRootProcessInstanceId", "updateExternalTaskLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricIncidentsByRootProcessInstanceId", "updateHistoricIncidentsByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricIncidentsByBatchId", "updateHistoricIncidentsByBatchId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateIdentityLinkLogByRootProcessInstanceId", "updateIdentityLinkLogByRootProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateUserOperationLogByProcessInstanceId", "updateUserOperationLogByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateExternalTaskLogByProcessInstanceId", "updateExternalTaskLogByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateHistoricIncidentsByProcessInstanceId", "updateHistoricIncidentsByProcessInstanceId_mysql");
            DbSqlSessionFactory.addDatabaseSpecificStatement(mysqlLikeDatabase, "updateIdentityLinkLogByProcessInstanceId", "updateIdentityLinkLogByProcessInstanceId_mysql");
            constants = new HashMap();
            constants.put("constant.event", "'event'");
            constants.put("constant.op_message", "CONCAT(NEW_VALUE_, '_|_', PROPERTY_)");
            constants.put("constant_for_update", "for update");
            constants.put("constant.datepart.quarter", "QUARTER");
            constants.put("constant.datepart.month", "MONTH");
            constants.put("constant.datepart.minute", "MINUTE");
            constants.put("constant.null.startTime", "null START_TIME_");
            constants.put("constant.varchar.cast", "'${key}'");
            constants.put("constant.integer.cast", "NULL");
            constants.put("constant.null.reporter", "NULL AS REPORTER_");
            dbSpecificConstants.put(mysqlLikeDatabase, constants);
        }
        databaseSpecificLimitBeforeStatements.put(POSTGRES, "");
        optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(POSTGRES, "");
        databaseSpecificLimitAfterStatements.put(POSTGRES, "LIMIT #{maxResults} OFFSET #{firstResult}");
        optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(POSTGRES, "LIMIT #{maxResults}");
        databaseSpecificLimitBeforeWithoutOffsetStatements.put(POSTGRES, "");
        databaseSpecificLimitAfterWithoutOffsetStatements.put(POSTGRES, "LIMIT #{maxResults}");
        databaseSpecificInnerLimitAfterStatements.put(POSTGRES, databaseSpecificLimitAfterStatements.get(POSTGRES));
        databaseSpecificLimitBetweenStatements.put(POSTGRES, "");
        databaseSpecificLimitBetweenFilterStatements.put(POSTGRES, "");
        databaseSpecificOrderByStatements.put(POSTGRES, defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put(POSTGRES, "");
        databaseSpecificDistinct.put(POSTGRES, "distinct");
        databaseSpecificEscapeChar.put(POSTGRES, defaultEscapeChar);
        databaseSpecificBitAnd1.put(POSTGRES, "");
        databaseSpecificBitAnd2.put(POSTGRES, " & ");
        databaseSpecificBitAnd3.put(POSTGRES, "");
        databaseSpecificDatepart1.put(POSTGRES, "extract(");
        databaseSpecificDatepart2.put(POSTGRES, " from ");
        databaseSpecificDatepart3.put(POSTGRES, ")");
        databaseSpecificDummyTable.put(POSTGRES, "");
        databaseSpecificTrueConstant.put(POSTGRES, "true");
        databaseSpecificFalseConstant.put(POSTGRES, "false");
        databaseSpecificIfNull.put(POSTGRES, "COALESCE");
        databaseSpecificDaysComparator.put(POSTGRES, "EXTRACT (DAY FROM #{currentTimestamp} - ${date}) >= ${days}");
        databaseSpecificCollationForCaseSensitivity.put(POSTGRES, "");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "insertByteArray", "insertByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "updateByteArray", "updateByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectByteArray", "selectByteArray_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectByteArrays", "selectByteArrays_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectResourceByDeploymentIdAndResourceName", "selectResourceByDeploymentIdAndResourceName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectResourceByDeploymentIdAndResourceNames", "selectResourceByDeploymentIdAndResourceNames_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectResourceByDeploymentIdAndResourceId", "selectResourceByDeploymentIdAndResourceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectResourceByDeploymentIdAndResourceIds", "selectResourceByDeploymentIdAndResourceIds_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectResourcesByDeploymentId", "selectResourcesByDeploymentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectLatestResourcesByDeploymentName", "selectLatestResourcesByDeploymentName_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "insertIdentityInfo", "insertIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "updateIdentityInfo", "updateIdentityInfo_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectIdentityInfoById", "selectIdentityInfoById_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectIdentityInfoByUserIdAndKey", "selectIdentityInfoByUserIdAndKey_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectIdentityInfoByUserId", "selectIdentityInfoByUserId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectIdentityInfoDetails", "selectIdentityInfoDetails_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "insertComment", "insertComment_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectCommentsByTaskId", "selectCommentsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectCommentsByProcessInstanceId", "selectCommentsByProcessInstanceId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectCommentByTaskIdAndCommentId", "selectCommentByTaskIdAndCommentId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectEventsByTaskId", "selectEventsByTaskId_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectFilterByQueryCriteria", "selectFilterByQueryCriteria_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "selectFilter", "selectFilter_postgres");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteAttachmentsByRemovalTime", "deleteAttachmentsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteCommentsByRemovalTime", "deleteCommentsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricActivityInstancesByRemovalTime", "deleteHistoricActivityInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricDecisionInputInstancesByRemovalTime", "deleteHistoricDecisionInputInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricDecisionInstancesByRemovalTime", "deleteHistoricDecisionInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricDecisionOutputInstancesByRemovalTime", "deleteHistoricDecisionOutputInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricDetailsByRemovalTime", "deleteHistoricDetailsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteExternalTaskLogByRemovalTime", "deleteExternalTaskLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricIdentityLinkLogByRemovalTime", "deleteHistoricIdentityLinkLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricIncidentsByRemovalTime", "deleteHistoricIncidentsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteJobLogByRemovalTime", "deleteJobLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricProcessInstancesByRemovalTime", "deleteHistoricProcessInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricTaskInstancesByRemovalTime", "deleteHistoricTaskInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricVariableInstancesByRemovalTime", "deleteHistoricVariableInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteUserOperationLogByRemovalTime", "deleteUserOperationLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteByteArraysByRemovalTime", "deleteByteArraysByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(POSTGRES, "deleteHistoricBatchesByRemovalTime", "deleteHistoricBatchesByRemovalTime_postgres_or_db2");
        constants = new HashMap();
        constants.put("constant.event", "'event'");
        constants.put("constant.op_message", "NEW_VALUE_ || '_|_' || PROPERTY_");
        constants.put("constant_for_update", "for update");
        constants.put("constant.datepart.quarter", "QUARTER");
        constants.put("constant.datepart.month", "MONTH");
        constants.put("constant.datepart.minute", "MINUTE");
        constants.put("constant.null.startTime", "null START_TIME_");
        constants.put("constant.varchar.cast", "cast('${key}' as varchar(64))");
        constants.put("constant.integer.cast", "cast(NULL as integer)");
        constants.put("constant.null.reporter", "CAST(NULL AS VARCHAR) AS REPORTER_");
        dbSpecificConstants.put(POSTGRES, constants);
        databaseSpecificLimitBeforeStatements.put(ORACLE, "select * from ( select a.*, ROWNUM rnum from (");
        optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(ORACLE, "select * from ( select a.*, ROWNUM rnum from (");
        databaseSpecificLimitAfterStatements.put(ORACLE, "  ) a where ROWNUM < #{lastRow}) where rnum  >= #{firstRow}");
        optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(ORACLE, "  ) a where ROWNUM <= #{maxResults})");
        databaseSpecificLimitBeforeWithoutOffsetStatements.put(ORACLE, "");
        databaseSpecificLimitAfterWithoutOffsetStatements.put(ORACLE, "AND ROWNUM <= #{maxResults}");
        databaseSpecificInnerLimitAfterStatements.put(ORACLE, databaseSpecificLimitAfterStatements.get(ORACLE));
        databaseSpecificLimitBetweenStatements.put(ORACLE, "");
        databaseSpecificLimitBetweenFilterStatements.put(ORACLE, "");
        databaseSpecificOrderByStatements.put(ORACLE, defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put(ORACLE, "");
        databaseSpecificDistinct.put(ORACLE, "distinct");
        databaseSpecificEscapeChar.put(ORACLE, defaultEscapeChar);
        databaseSpecificDummyTable.put(ORACLE, "FROM DUAL");
        databaseSpecificBitAnd1.put(ORACLE, "BITAND(");
        databaseSpecificBitAnd2.put(ORACLE, ",");
        databaseSpecificBitAnd3.put(ORACLE, ")");
        databaseSpecificDatepart1.put(ORACLE, "to_number(to_char(");
        databaseSpecificDatepart2.put(ORACLE, ",");
        databaseSpecificDatepart3.put(ORACLE, "))");
        databaseSpecificTrueConstant.put(ORACLE, "1");
        databaseSpecificFalseConstant.put(ORACLE, "0");
        databaseSpecificIfNull.put(ORACLE, "NVL");
        databaseSpecificDaysComparator.put(ORACLE, "${date} <= #{currentTimestamp} - ${days}");
        databaseSpecificCollationForCaseSensitivity.put(ORACLE, "");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricProcessInstanceDurationReport", "selectHistoricProcessInstanceDurationReport_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricTaskInstanceDurationReport", "selectHistoricTaskInstanceDurationReport_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricTaskInstanceCountByTaskNameReport", "selectHistoricTaskInstanceCountByTaskNameReport_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectFilterByQueryCriteria", "selectFilterByQueryCriteria_oracleDb2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricProcessInstanceIdsForCleanup", "selectHistoricProcessInstanceIdsForCleanup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricDecisionInstanceIdsForCleanup", "selectHistoricDecisionInstanceIdsForCleanup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricCaseInstanceIdsForCleanup", "selectHistoricCaseInstanceIdsForCleanup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "selectHistoricBatchIdsForCleanup", "selectHistoricBatchIdsForCleanup_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteAttachmentsByRemovalTime", "deleteAttachmentsByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteCommentsByRemovalTime", "deleteCommentsByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricActivityInstancesByRemovalTime", "deleteHistoricActivityInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricDecisionInputInstancesByRemovalTime", "deleteHistoricDecisionInputInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricDecisionInstancesByRemovalTime", "deleteHistoricDecisionInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricDecisionOutputInstancesByRemovalTime", "deleteHistoricDecisionOutputInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricDetailsByRemovalTime", "deleteHistoricDetailsByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteExternalTaskLogByRemovalTime", "deleteExternalTaskLogByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricIdentityLinkLogByRemovalTime", "deleteHistoricIdentityLinkLogByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricIncidentsByRemovalTime", "deleteHistoricIncidentsByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteJobLogByRemovalTime", "deleteJobLogByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricProcessInstancesByRemovalTime", "deleteHistoricProcessInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricTaskInstancesByRemovalTime", "deleteHistoricTaskInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricVariableInstancesByRemovalTime", "deleteHistoricVariableInstancesByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteUserOperationLogByRemovalTime", "deleteUserOperationLogByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteByteArraysByRemovalTime", "deleteByteArraysByRemovalTime_oracle");
        DbSqlSessionFactory.addDatabaseSpecificStatement(ORACLE, "deleteHistoricBatchesByRemovalTime", "deleteHistoricBatchesByRemovalTime_oracle");
        constants = new HashMap();
        constants.put("constant.event", "cast('event' as nvarchar2(255))");
        constants.put("constant.op_message", "NEW_VALUE_ || '_|_' || PROPERTY_");
        constants.put("constant_for_update", "for update");
        constants.put("constant.datepart.quarter", "'Q'");
        constants.put("constant.datepart.month", "'MM'");
        constants.put("constant.datepart.minute", "'MI'");
        constants.put("constant.null.startTime", "null START_TIME_");
        constants.put("constant.varchar.cast", "'${key}'");
        constants.put("constant.integer.cast", "NULL");
        constants.put("constant.null.reporter", "NULL AS REPORTER_");
        dbSpecificConstants.put(ORACLE, constants);
        databaseSpecificLimitBeforeStatements.put(DB2, "SELECT SUB.* FROM (");
        optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(DB2, "");
        databaseSpecificInnerLimitAfterStatements.put(DB2, ")RES ) SUB WHERE SUB.rnk >= #{firstRow} AND SUB.rnk < #{lastRow}");
        databaseSpecificLimitAfterStatements.put(DB2, databaseSpecificInnerLimitAfterStatements.get(DB2) + " ORDER BY SUB.rnk");
        optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(DB2, "FETCH FIRST ${maxResults} ROWS ONLY");
        databaseSpecificLimitBetweenStatements.put(DB2, ", row_number() over (ORDER BY ${internalOrderBy}) rnk FROM ( select distinct RES.* ");
        databaseSpecificLimitBetweenFilterStatements.put(DB2, ", row_number() over (ORDER BY ${internalOrderBy}) rnk FROM ( select distinct RES.ID_, RES.REV_, RES.RESOURCE_TYPE_, RES.NAME_, RES.OWNER_ ");
        databaseSpecificLimitBeforeWithoutOffsetStatements.put(DB2, "");
        databaseSpecificLimitAfterWithoutOffsetStatements.put(DB2, "FETCH FIRST ${maxResults} ROWS ONLY");
        databaseSpecificOrderByStatements.put(DB2, defaultOrderBy);
        databaseSpecificLimitBeforeNativeQueryStatements.put(DB2, "SELECT SUB.* FROM ( select RES.* , row_number() over (ORDER BY ${internalOrderBy}) rnk FROM (");
        databaseSpecificDistinct.put(DB2, "");
        databaseSpecificEscapeChar.put(DB2, defaultEscapeChar);
        databaseSpecificBitAnd1.put(DB2, "BITAND(");
        databaseSpecificBitAnd2.put(DB2, ", CAST(");
        databaseSpecificBitAnd3.put(DB2, " AS Integer))");
        databaseSpecificDatepart1.put(DB2, "");
        databaseSpecificDatepart2.put(DB2, "(");
        databaseSpecificDatepart3.put(DB2, ")");
        databaseSpecificDummyTable.put(DB2, "FROM SYSIBM.SYSDUMMY1");
        databaseSpecificTrueConstant.put(DB2, "1");
        databaseSpecificFalseConstant.put(DB2, "0");
        databaseSpecificIfNull.put(DB2, "NVL");
        databaseSpecificDaysComparator.put(DB2, "${date} + ${days} DAYS <= #{currentTimestamp}");
        databaseSpecificCollationForCaseSensitivity.put(DB2, "");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectMeterLogAggregatedByTimeInterval", "selectMeterLogAggregatedByTimeInterval_db2_or_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectExecutionByNativeQuery", "selectExecutionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricActivityInstanceByNativeQuery", "selectHistoricActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricCaseActivityInstanceByNativeQuery", "selectHistoricCaseActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricProcessInstanceByNativeQuery", "selectHistoricProcessInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricCaseInstanceByNativeQuery", "selectHistoricCaseInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricTaskInstanceByNativeQuery", "selectHistoricTaskInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricVariableInstanceByNativeQuery", "selectHistoricVariableInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectTaskByNativeQuery", "selectTaskByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectUserByNativeQuery", "selectUserByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectHistoricDecisionInstancesByNativeQuery", "selectHistoricDecisionInstancesByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "selectFilterByQueryCriteria", "selectFilterByQueryCriteria_oracleDb2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteAttachmentsByRemovalTime", "deleteAttachmentsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteCommentsByRemovalTime", "deleteCommentsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricActivityInstancesByRemovalTime", "deleteHistoricActivityInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricDecisionInputInstancesByRemovalTime", "deleteHistoricDecisionInputInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricDecisionInstancesByRemovalTime", "deleteHistoricDecisionInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricDecisionOutputInstancesByRemovalTime", "deleteHistoricDecisionOutputInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricDetailsByRemovalTime", "deleteHistoricDetailsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteExternalTaskLogByRemovalTime", "deleteExternalTaskLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricIdentityLinkLogByRemovalTime", "deleteHistoricIdentityLinkLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricIncidentsByRemovalTime", "deleteHistoricIncidentsByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteJobLogByRemovalTime", "deleteJobLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricProcessInstancesByRemovalTime", "deleteHistoricProcessInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricTaskInstancesByRemovalTime", "deleteHistoricTaskInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricVariableInstancesByRemovalTime", "deleteHistoricVariableInstancesByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteUserOperationLogByRemovalTime", "deleteUserOperationLogByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteByteArraysByRemovalTime", "deleteByteArraysByRemovalTime_postgres_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(DB2, "deleteHistoricBatchesByRemovalTime", "deleteHistoricBatchesByRemovalTime_postgres_or_db2");
        constants = new HashMap();
        constants.put("constant.event", "'event'");
        constants.put("constant.op_message", "CAST(CONCAT(CONCAT(COALESCE(NEW_VALUE_,''), '_|_'), COALESCE(PROPERTY_,'')) as varchar(255))");
        constants.put("constant_for_update", "for read only with rs use and keep update locks");
        constants.put("constant.datepart.quarter", "QUARTER");
        constants.put("constant.datepart.month", "MONTH");
        constants.put("constant.datepart.minute", "MINUTE");
        constants.put("constant.null.startTime", "CAST(NULL as timestamp) as START_TIME_");
        constants.put("constant.varchar.cast", "cast('${key}' as varchar(64))");
        constants.put("constant.integer.cast", "cast(NULL as integer)");
        constants.put("constant.null.reporter", "CAST(NULL AS VARCHAR(255)) AS REPORTER_");
        dbSpecificConstants.put(DB2, constants);
        databaseSpecificLimitBeforeStatements.put(MSSQL, "SELECT SUB.* FROM (");
        optimizeDatabaseSpecificLimitBeforeWithoutOffsetStatements.put(MSSQL, "");
        databaseSpecificInnerLimitAfterStatements.put(MSSQL, ")RES ) SUB WHERE SUB.rnk >= #{firstRow} AND SUB.rnk < #{lastRow}");
        databaseSpecificLimitAfterStatements.put(MSSQL, databaseSpecificInnerLimitAfterStatements.get(MSSQL) + " ORDER BY SUB.rnk");
        optimizeDatabaseSpecificLimitAfterWithoutOffsetStatements.put(MSSQL, "");
        databaseSpecificLimitBetweenStatements.put(MSSQL, ", row_number() over (ORDER BY ${internalOrderBy}) rnk FROM ( select distinct RES.* ");
        databaseSpecificLimitBetweenFilterStatements.put(MSSQL, "");
        databaseSpecificLimitBeforeWithoutOffsetStatements.put(MSSQL, "TOP (#{maxResults})");
        databaseSpecificLimitAfterWithoutOffsetStatements.put(MSSQL, "");
        databaseSpecificOrderByStatements.put(MSSQL, "");
        databaseSpecificLimitBeforeNativeQueryStatements.put(MSSQL, "SELECT SUB.* FROM ( select RES.* , row_number() over (ORDER BY ${internalOrderBy}) rnk FROM (");
        databaseSpecificDistinct.put(MSSQL, "");
        databaseSpecificEscapeChar.put(MSSQL, defaultEscapeChar);
        databaseSpecificBitAnd1.put(MSSQL, "");
        databaseSpecificBitAnd2.put(MSSQL, " &");
        databaseSpecificBitAnd3.put(MSSQL, "");
        databaseSpecificDatepart1.put(MSSQL, "datepart(");
        databaseSpecificDatepart2.put(MSSQL, ",");
        databaseSpecificDatepart3.put(MSSQL, ")");
        databaseSpecificDummyTable.put(MSSQL, "");
        databaseSpecificTrueConstant.put(MSSQL, "1");
        databaseSpecificFalseConstant.put(MSSQL, "0");
        databaseSpecificIfNull.put(MSSQL, "ISNULL");
        databaseSpecificDaysComparator.put(MSSQL, "DATEDIFF(DAY, ${date}, #{currentTimestamp}) >= ${days}");
        databaseSpecificCollationForCaseSensitivity.put(MSSQL, "COLLATE Latin1_General_CS_AS");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectMeterLogAggregatedByTimeInterval", "selectMeterLogAggregatedByTimeInterval_db2_or_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectExecutionByNativeQuery", "selectExecutionByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricActivityInstanceByNativeQuery", "selectHistoricActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricCaseActivityInstanceByNativeQuery", "selectHistoricCaseActivityInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricProcessInstanceByNativeQuery", "selectHistoricProcessInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricCaseInstanceByNativeQuery", "selectHistoricCaseInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricTaskInstanceByNativeQuery", "selectHistoricTaskInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricVariableInstanceByNativeQuery", "selectHistoricVariableInstanceByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectTaskByNativeQuery", "selectTaskByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectUserByNativeQuery", "selectUserByNativeQuery_mssql_or_db2");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "lockDeploymentLockProperty", "lockDeploymentLockProperty_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "lockHistoryCleanupJobLockProperty", "lockHistoryCleanupJobLockProperty_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "lockStartupLockProperty", "lockStartupLockProperty_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectEventSubscriptionsByNameAndExecution", "selectEventSubscriptionsByNameAndExecution_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectEventSubscriptionsByExecutionAndType", "selectEventSubscriptionsByExecutionAndType_mssql");
        DbSqlSessionFactory.addDatabaseSpecificStatement(MSSQL, "selectHistoricDecisionInstancesByNativeQuery", "selectHistoricDecisionInstancesByNativeQuery_mssql_or_db2");
        constants = new HashMap();
        constants.put("constant.event", "'event'");
        constants.put("constant.op_message", "NEW_VALUE_ + '_|_' + PROPERTY_");
        constants.put("constant.datepart.quarter", "QUARTER");
        constants.put("constant.datepart.month", "MONTH");
        constants.put("constant.datepart.minute", "MINUTE");
        constants.put("constant.null.startTime", "CAST(NULL AS datetime2) AS START_TIME_");
        constants.put("constant.varchar.cast", "'${key}'");
        constants.put("constant.integer.cast", "NULL");
        constants.put("constant.null.reporter", "NULL AS REPORTER_");
        dbSpecificConstants.put(MSSQL, constants);
    }
}

