/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import java.util.HashMap;
import org.camunda.bpm.engine.impl.calendar.BusinessCalendar;
import org.camunda.bpm.engine.impl.calendar.CycleBusinessCalendar;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.RepeatingFailedJobListener;
import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class TimerEntity
extends JobEntity {
    public static final String TYPE = "timer";
    private static final long serialVersionUID = 1L;
    protected String repeat;

    public TimerEntity() {
    }

    public TimerEntity(TimerDeclarationImpl timerDeclaration) {
        this.repeat = timerDeclaration.getRepeat();
    }

    protected TimerEntity(TimerEntity te) {
        this.jobHandlerConfiguration = te.jobHandlerConfiguration;
        this.jobHandlerType = te.jobHandlerType;
        this.isExclusive = te.isExclusive;
        this.repeat = te.repeat;
        this.retries = te.retries;
        this.executionId = te.executionId;
        this.processInstanceId = te.processInstanceId;
        this.jobDefinitionId = te.jobDefinitionId;
        this.suspensionState = te.suspensionState;
        this.deploymentId = te.deploymentId;
        this.processDefinitionId = te.processDefinitionId;
        this.processDefinitionKey = te.processDefinitionKey;
        this.tenantId = te.tenantId;
        this.priority = te.priority;
    }

    @Override
    protected void preExecute(CommandContext commandContext) {
        if (this.getJobHandler() instanceof TimerEventJobHandler) {
            Date newDueDate;
            TimerEventJobHandler.TimerJobConfiguration configuration = (TimerEventJobHandler.TimerJobConfiguration)this.getJobHandlerConfiguration();
            if (this.repeat != null && !configuration.isFollowUpJobCreated() && (newDueDate = this.calculateRepeat()) != null) {
                ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
                CommandExecutor commandExecutor = processEngineConfiguration.getCommandExecutorTxRequiresNew();
                RepeatingFailedJobListener listener = this.createRepeatingFailedJobListener(commandExecutor);
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
                this.createNewTimerJob(newDueDate);
            }
        }
    }

    protected RepeatingFailedJobListener createRepeatingFailedJobListener(CommandExecutor commandExecutor) {
        return new RepeatingFailedJobListener(commandExecutor, this.getId());
    }

    public void createNewTimerJob(Date dueDate) {
        TimerEntity newTimer = new TimerEntity(this);
        newTimer.setDuedate(dueDate);
        Context.getCommandContext().getJobManager().schedule(newTimer);
    }

    public Date calculateRepeat() {
        BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
        return businessCalendar.resolveDuedate(this.repeat);
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Object getPersistentState() {
        HashMap persistentState = (HashMap)super.getPersistentState();
        persistentState.put("repeat", this.repeat);
        return persistentState;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[repeat=" + this.repeat + ", id=" + this.id + ", revision=" + this.revision + ", duedate=" + this.duedate + ", lockOwner=" + this.lockOwner + ", lockExpirationTime=" + this.lockExpirationTime + ", executionId=" + this.executionId + ", processInstanceId=" + this.processInstanceId + ", isExclusive=" + this.isExclusive + ", retries=" + this.retries + ", jobHandlerType=" + this.jobHandlerType + ", jobHandlerConfiguration=" + this.jobHandlerConfiguration + ", exceptionByteArray=" + this.exceptionByteArray + ", exceptionByteArrayId=" + this.exceptionByteArrayId + ", exceptionMessage=" + this.exceptionMessage + ", deploymentId=" + this.deploymentId + "]";
    }
}

