/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.nio.charset.StandardCharsets;
import org.camunda.bpm.engine.impl.cmd.LicenseCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class GetLicenseKeyCmd
extends LicenseCmd
implements Command<String> {
    @Override
    public String execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCamundaAdmin();
        ResourceEntity licenseResource = commandContext.getResourceManager().findLicenseKeyResource();
        if (licenseResource != null) {
            return new String(licenseResource.getBytes(), StandardCharsets.UTF_8);
        }
        PropertyEntity licenseProperty = commandContext.getPropertyManager().findPropertyById("camunda-license-key");
        if (licenseProperty != null) {
            return licenseProperty.getValue();
        }
        return null;
    }
}

