/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.SetRetriesBatchConfiguration;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractSetExternalTaskRetriesCmd;
import org.camunda.bpm.engine.impl.cmd.UpdateExternalTaskRetriesBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.BatchUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetExternalTasksRetriesBatchCmd
extends AbstractSetExternalTaskRetriesCmd<Batch> {
    public SetExternalTasksRetriesBatchCmd(UpdateExternalTaskRetriesBuilderImpl builder) {
        super(builder);
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        List<String> externalTaskIds = this.collectExternalTaskIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "externalTaskIds", externalTaskIds);
        this.checkPermissions(commandContext);
        this.writeUserOperationLog(commandContext, this.builder.getRetries(), externalTaskIds.size(), true);
        BatchEntity batch = this.createBatch(commandContext, externalTaskIds);
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected void checkPermissions(CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateBatch(BatchPermissions.CREATE_BATCH_SET_EXTERNAL_TASK_RETRIES);
        }
    }

    protected BatchEntity createBatch(CommandContext commandContext, Collection<String> processInstanceIds) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        BatchJobHandler<SetRetriesBatchConfiguration> batchJobHandler = this.getBatchJobHandler(processEngineConfiguration);
        SetRetriesBatchConfiguration configuration = new SetRetriesBatchConfiguration(new ArrayList<String>(processInstanceIds), this.builder.getRetries());
        BatchEntity batch = new BatchEntity();
        batch.setType(batchJobHandler.getType());
        batch.setTotalJobs(BatchUtil.calculateBatchSize(processEngineConfiguration, configuration));
        batch.setBatchJobsPerSeed(processEngineConfiguration.getBatchJobsPerSeed());
        batch.setInvocationsPerBatchJob(processEngineConfiguration.getInvocationsPerBatchJob());
        batch.setConfigurationBytes(batchJobHandler.writeConfiguration(configuration));
        commandContext.getBatchManager().insertBatch(batch);
        return batch;
    }

    protected BatchJobHandler<SetRetriesBatchConfiguration> getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("set-external-task-retries");
    }
}

