/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.InputStream;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.exception.DeploymentResourceNotFoundException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.form.FormData;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;

public abstract class AbstractGetDeployedFormCmd
implements Command<InputStream> {
    protected static String EMBEDDED_KEY = "embedded:";
    protected static String CAMUNDA_FORMS_KEY = "camunda-forms:";
    protected static int EMBEDDED_KEY_LENGTH = EMBEDDED_KEY.length();
    protected static int CAMUNDA_FORMS_KEY_LENGTH = CAMUNDA_FORMS_KEY.length();
    protected static String DEPLOYMENT_KEY = "deployment:";
    protected static int DEPLOYMENT_KEY_LENGTH = DEPLOYMENT_KEY.length();

    @Override
    public InputStream execute(final CommandContext commandContext) {
        this.checkAuthorization(commandContext);
        final FormData formData = this.getFormData(commandContext);
        String formKey = formData.getFormKey();
        if (formKey == null) {
            throw new BadUserRequestException("The form key is not set.");
        }
        final String resourceName = this.getResourceName(formKey);
        try {
            return commandContext.runWithoutAuthorization(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return new GetDeploymentResourceCmd(formData.getDeploymentId(), resourceName).execute(commandContext);
                }
            });
        }
        catch (DeploymentResourceNotFoundException e) {
            throw new NotFoundException("The form with the resource name '" + resourceName + "' cannot be found in deployment.", e);
        }
    }

    protected String getResourceName(String formKey) {
        String resourceName = formKey;
        if (resourceName.startsWith(EMBEDDED_KEY)) {
            resourceName = resourceName.substring(EMBEDDED_KEY_LENGTH, resourceName.length());
        } else if (resourceName.startsWith(CAMUNDA_FORMS_KEY)) {
            resourceName = resourceName.substring(CAMUNDA_FORMS_KEY_LENGTH, resourceName.length());
        }
        if (!resourceName.startsWith(DEPLOYMENT_KEY)) {
            throw new BadUserRequestException("The form key '" + formKey + "' does not reference a deployed form.");
        }
        resourceName = resourceName.substring(DEPLOYMENT_KEY_LENGTH, resourceName.length());
        return resourceName;
    }

    protected abstract FormData getFormData(CommandContext var1);

    protected abstract void checkAuthorization(CommandContext var1);
}

