/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.HistoricDetailQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.ProcessInstantiationBuilderImpl;
import org.camunda.bpm.engine.impl.RestartProcessInstanceBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.AbstractRestartProcessInstanceCmd;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;

public class RestartProcessInstancesCmd
extends AbstractRestartProcessInstanceCmd<Void> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected boolean writeUserOperationLog;

    public RestartProcessInstancesCmd(CommandExecutor commandExecutor, RestartProcessInstanceBuilderImpl builder, boolean writeUserOperationLog) {
        super(commandExecutor, builder);
        this.writeUserOperationLog = writeUserOperationLog;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getInstructions();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Restart instructions cannot be empty", "instructions", instructions);
        Collection<String> processInstanceIds = this.collectProcessInstanceIds();
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "Process instance ids cannot be empty", "Process instance ids", processInstanceIds);
        EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "Process instance ids cannot be null", "Process instance ids", processInstanceIds);
        ProcessDefinitionEntity processDefinition = this.getProcessDefinition(commandContext, this.builder.getProcessDefinitionId());
        EnsureUtil.ensureNotNull("Process definition cannot be found", "processDefinition", (Object)processDefinition);
        this.checkAuthorization(commandContext, processDefinition);
        if (this.writeUserOperationLog) {
            this.writeUserOperationLog(commandContext, processDefinition, processInstanceIds.size(), false);
        }
        String processDefinitionId = this.builder.getProcessDefinitionId();
        Runnable runnable = () -> {
            for (String processInstanceId : processInstanceIds) {
                HistoricProcessInstance historicProcessInstance = this.getHistoricProcessInstance(commandContext, processInstanceId);
                EnsureUtil.ensureNotNull(BadUserRequestException.class, "Historic process instance cannot be found", "historicProcessInstanceId", (Object)historicProcessInstance);
                this.ensureHistoricProcessInstanceNotActive(historicProcessInstance);
                this.ensureSameProcessDefinition(historicProcessInstance, processDefinitionId);
                ProcessInstantiationBuilderImpl instantiationBuilder = this.getProcessInstantiationBuilder(this.commandExecutor, processDefinitionId);
                this.applyProperties(instantiationBuilder, processDefinition, historicProcessInstance);
                ProcessInstanceModificationBuilderImpl modificationBuilder = instantiationBuilder.getModificationBuilder();
                modificationBuilder.setModificationOperations(instructions);
                VariableMap variables = this.collectVariables(commandContext, historicProcessInstance);
                instantiationBuilder.setVariables((Map)variables);
                instantiationBuilder.execute(this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings());
            }
        };
        ProcessApplicationContextUtil.doContextSwitch(runnable, processDefinition);
        return null;
    }

    protected void checkAuthorization(CommandContext commandContext, ProcessDefinition processDefinition) {
        commandContext.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, processDefinition.getKey());
    }

    protected HistoricProcessInstance getHistoricProcessInstance(CommandContext commandContext, String processInstanceId) {
        HistoryService historyService = commandContext.getProcessEngineConfiguration().getHistoryService();
        return (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
    }

    protected void ensureSameProcessDefinition(HistoricProcessInstance instance, String processDefinitionId) {
        if (!processDefinitionId.equals(instance.getProcessDefinitionId())) {
            throw LOG.processDefinitionOfHistoricInstanceDoesNotMatchTheGivenOne(instance, processDefinitionId);
        }
    }

    protected void ensureHistoricProcessInstanceNotActive(HistoricProcessInstance instance) {
        if (instance.getEndTime() == null) {
            throw LOG.historicProcessInstanceActive(instance);
        }
    }

    protected ProcessInstantiationBuilderImpl getProcessInstantiationBuilder(CommandExecutor commandExecutor, String processDefinitionId) {
        return (ProcessInstantiationBuilderImpl)ProcessInstantiationBuilderImpl.createProcessInstanceById(commandExecutor, processDefinitionId);
    }

    protected void applyProperties(ProcessInstantiationBuilderImpl instantiationBuilder, ProcessDefinition processDefinition, HistoricProcessInstance processInstance) {
        String tenantId = processInstance.getTenantId();
        if (processDefinition.getTenantId() == null && tenantId != null) {
            instantiationBuilder.tenantId(tenantId);
        }
        if (!this.builder.isWithoutBusinessKey()) {
            instantiationBuilder.businessKey(processInstance.getBusinessKey());
        }
    }

    protected VariableMap collectVariables(CommandContext commandContext, HistoricProcessInstance processInstance) {
        VariableMap variables = null;
        variables = this.builder.isInitialVariables() ? this.collectInitialVariables(commandContext, processInstance) : this.collectLastVariables(commandContext, processInstance);
        return variables;
    }

    protected VariableMap collectInitialVariables(CommandContext commandContext, HistoricProcessInstance processInstance) {
        HistoricActivityInstance startActivityInstance;
        HistoryService historyService = commandContext.getProcessEngineConfiguration().getHistoryService();
        List historicDetails = historyService.createHistoricDetailQuery().variableUpdates().executionId(processInstance.getId()).initial().list();
        if (historicDetails.size() == 0 && (startActivityInstance = this.resolveStartActivityInstance(processInstance)) != null) {
            HistoricDetailQueryImpl queryWithStartActivities = (HistoricDetailQueryImpl)historyService.createHistoricDetailQuery().variableUpdates().activityInstanceId(startActivityInstance.getId()).executionId(processInstance.getId());
            historicDetails = queryWithStartActivities.sequenceCounter(1L).list();
        }
        VariableMapImpl variables = new VariableMapImpl();
        for (HistoricDetail detail : historicDetails) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)detail;
            variables.putValueTyped(variableUpdate.getVariableName(), variableUpdate.getTypedValue());
        }
        return variables;
    }

    protected VariableMap collectLastVariables(CommandContext commandContext, HistoricProcessInstance processInstance) {
        HistoryService historyService = commandContext.getProcessEngineConfiguration().getHistoryService();
        List historicVariables = historyService.createHistoricVariableInstanceQuery().executionIdIn(processInstance.getId()).list();
        VariableMapImpl variables = new VariableMapImpl();
        for (HistoricVariableInstance variable : historicVariables) {
            variables.putValueTyped(variable.getName(), variable.getTypedValue());
        }
        return variables;
    }

    protected HistoricActivityInstance resolveStartActivityInstance(HistoricProcessInstance processInstance) {
        HistoryService historyService = Context.getProcessEngineConfiguration().getHistoryService();
        String processInstanceId = processInstance.getId();
        String startActivityId = processInstance.getStartActivityId();
        EnsureUtil.ensureNotNull("startActivityId", (Object)startActivityId);
        List historicActivityInstances = ((HistoricActivityInstanceQuery)historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId(startActivityId).orderPartiallyByOccurrence().asc()).list();
        EnsureUtil.ensureNotEmpty("historicActivityInstances", historicActivityInstances);
        HistoricActivityInstance startActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
        return startActivityInstance;
    }
}

