/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg.auth;

import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.ProcessInstancePermissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.authorization.TaskPermissions;
import org.camunda.bpm.engine.authorization.UserOperationLogCategoryPermissions;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.CompositePermissionCheck;
import org.camunda.bpm.engine.impl.db.PermissionCheckBuilder;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionRequirementsDefinitionEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;

public class AuthorizationCommandChecker
implements CommandChecker {
    @Override
    public void checkEvaluateDecision(DecisionDefinition decisionDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE_INSTANCE, Resources.DECISION_DEFINITION, decisionDefinition.getKey());
    }

    @Override
    public void checkCreateProcessInstance(ProcessDefinition processDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.PROCESS_INSTANCE);
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE_INSTANCE, Resources.PROCESS_DEFINITION, processDefinition.getKey());
    }

    @Override
    public void checkReadProcessDefinition(ProcessDefinition processDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.PROCESS_DEFINITION, processDefinition.getKey());
    }

    @Override
    public void checkCreateCaseInstance(CaseDefinition caseDefinition) {
    }

    @Override
    public void checkUpdateProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null) {
            this.checkUpdateProcessDefinitionByKey(processDefinition.getKey());
        }
    }

    @Override
    public void checkUpdateProcessDefinitionSuspensionStateById(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null) {
            this.checkUpdateProcessDefinitionSuspensionStateByKey(processDefinition.getKey());
        }
    }

    @Override
    public void checkUpdateDecisionDefinitionById(String decisionDefinitionId) {
        DecisionDefinitionEntity decisionDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (decisionDefinition = this.findLatestDecisionDefinitionById(decisionDefinitionId)) != null) {
            this.checkUpdateDecisionDefinition(decisionDefinition);
        }
    }

    @Override
    public void checkUpdateProcessDefinitionByKey(String processDefinitionKey) {
        this.getAuthorizationManager().checkAuthorization(Permissions.UPDATE, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    @Override
    public void checkUpdateProcessDefinitionSuspensionStateByKey(String processDefinitionKey) {
        CompositePermissionCheck suspensionStatePermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinitionKey, ProcessDefinitionPermissions.SUSPEND).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinitionKey, Permissions.UPDATE).build();
        this.getAuthorizationManager().checkAuthorization(suspensionStatePermission);
    }

    @Override
    public void checkDeleteProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null) {
            this.checkDeleteProcessDefinitionByKey(processDefinition.getKey());
        }
    }

    @Override
    public void checkDeleteProcessDefinitionByKey(String processDefinitionKey) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    @Override
    public void checkUpdateProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null) {
            this.checkUpdateProcessInstanceByProcessDefinitionKey(processDefinition.getKey());
        }
    }

    @Override
    public void checkUpdateRetriesProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null) {
            CompositePermissionCheck retryJobPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, "*", ProcessInstancePermissions.RETRY_JOB).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), ProcessDefinitionPermissions.RETRY_JOB).atomicCheckForResourceId(Resources.PROCESS_INSTANCE, "*", Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), Permissions.UPDATE_INSTANCE).build();
            this.getAuthorizationManager().checkAuthorization(retryJobPermission);
        }
    }

    @Override
    public void checkUpdateProcessInstanceSuspensionStateByProcessDefinitionId(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (this.getAuthorizationManager().isAuthorizationEnabled() && (processDefinition = this.findLatestProcessDefinitionById(processDefinitionId)) != null) {
            this.checkUpdateProcessInstanceSuspensionStateByProcessDefinitionKey(processDefinition.getKey());
        }
    }

    @Override
    public void checkUpdateProcessInstanceByProcessDefinitionKey(String processDefinitionKey) {
        CompositePermissionCheck suspensionStatePermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, null, Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinitionKey, Permissions.UPDATE_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(suspensionStatePermission);
    }

    @Override
    public void checkUpdateProcessInstanceSuspensionStateByProcessDefinitionKey(String processDefinitionKey) {
        CompositePermissionCheck suspensionStatePermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, null, ProcessInstancePermissions.SUSPEND).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinitionKey, ProcessDefinitionPermissions.SUSPEND_INSTANCE).atomicCheckForResourceId(Resources.PROCESS_INSTANCE, null, Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinitionKey, Permissions.UPDATE_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(suspensionStatePermission);
    }

    @Override
    public void checkReadProcessInstance(String processInstanceId) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution != null) {
            this.checkReadProcessInstance(execution);
        }
    }

    @Override
    public void checkDeleteProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        CompositePermissionCheck deleteInstancePermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, execution.getProcessInstanceId(), Permissions.DELETE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), Permissions.DELETE_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(deleteInstancePermission);
    }

    @Override
    public void checkUpdateProcessInstanceById(String processInstanceId) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution != null) {
            this.checkUpdateProcessInstance(execution);
        }
    }

    @Override
    public void checkUpdateProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        CompositePermissionCheck suspensionStatePermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, execution.getProcessInstanceId(), Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), Permissions.UPDATE_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(suspensionStatePermission);
    }

    @Override
    public void checkUpdateProcessInstanceVariables(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        CompositePermissionCheck suspensionStatePermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, execution.getProcessInstanceId(), ProcessInstancePermissions.UPDATE_VARIABLE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), ProcessDefinitionPermissions.UPDATE_INSTANCE_VARIABLE).atomicCheckForResourceId(Resources.PROCESS_INSTANCE, execution.getProcessInstanceId(), Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), Permissions.UPDATE_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(suspensionStatePermission);
    }

    @Override
    public void checkUpdateProcessInstanceSuspensionStateById(String processInstanceId) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution != null) {
            this.checkUpdateProcessInstanceSuspensionState(execution);
        }
    }

    public void checkUpdateProcessInstanceSuspensionState(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        CompositePermissionCheck suspensionStatePermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, execution.getProcessInstanceId(), ProcessInstancePermissions.SUSPEND).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), ProcessDefinitionPermissions.SUSPEND_INSTANCE).atomicCheckForResourceId(Resources.PROCESS_INSTANCE, execution.getProcessInstanceId(), Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), Permissions.UPDATE_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(suspensionStatePermission);
    }

    @Override
    public void checkUpdateJob(JobEntity job) {
        if (job.getProcessDefinitionKey() == null) {
            return;
        }
        CompositePermissionCheck retryJobPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, job.getProcessInstanceId(), Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, job.getProcessDefinitionKey(), Permissions.UPDATE_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(retryJobPermission);
    }

    @Override
    public void checkUpdateRetriesJob(JobEntity job) {
        if (job.getProcessDefinitionKey() == null) {
            return;
        }
        CompositePermissionCheck retryJobPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, job.getProcessInstanceId(), ProcessInstancePermissions.RETRY_JOB).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, job.getProcessDefinitionKey(), ProcessDefinitionPermissions.RETRY_JOB).atomicCheckForResourceId(Resources.PROCESS_INSTANCE, job.getProcessInstanceId(), Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, job.getProcessDefinitionKey(), Permissions.UPDATE_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(retryJobPermission);
    }

    @Override
    public void checkCreateMigrationPlan(ProcessDefinition sourceProcessDefinition, ProcessDefinition targetProcessDefinition) {
        this.checkReadProcessDefinition(sourceProcessDefinition);
        this.checkReadProcessDefinition(targetProcessDefinition);
    }

    @Override
    public void checkMigrateProcessInstance(ExecutionEntity processInstance, ProcessDefinition targetProcessDefinition) {
    }

    @Override
    public void checkReadProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
        CompositePermissionCheck readProcessInstancePermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, execution.getProcessInstanceId(), Permissions.READ).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), Permissions.READ_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(readProcessInstancePermission);
    }

    @Override
    public void checkReadProcessInstanceVariable(ExecutionEntity execution) {
        if (this.getAuthorizationManager().isEnsureSpecificVariablePermission()) {
            ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
            CompositePermissionCheck readProcessInstancePermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), ProcessDefinitionPermissions.READ_INSTANCE_VARIABLE).build();
            this.getAuthorizationManager().checkAuthorization(readProcessInstancePermission);
        } else {
            this.checkReadProcessInstance(execution);
        }
    }

    @Override
    public void checkReadJob(JobEntity job) {
        if (job.getProcessDefinitionKey() == null) {
            return;
        }
        CompositePermissionCheck readJobPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_INSTANCE, job.getProcessInstanceId(), Permissions.READ).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, job.getProcessDefinitionKey(), Permissions.READ_INSTANCE).build();
        this.getAuthorizationManager().checkAuthorization(readJobPermission);
    }

    @Override
    public void checkReadTask(TaskEntity task) {
        this.checkTaskPermission(task, Permissions.READ_TASK, Permissions.READ);
    }

    @Override
    public void checkReadTaskVariable(TaskEntity task) {
        Enum readStandaloneTaskPermission;
        Enum readProcessInstanceTaskPermission;
        if (this.getAuthorizationManager().isEnsureSpecificVariablePermission()) {
            readProcessInstanceTaskPermission = ProcessDefinitionPermissions.READ_TASK_VARIABLE;
            readStandaloneTaskPermission = TaskPermissions.READ_VARIABLE;
        } else {
            readProcessInstanceTaskPermission = Permissions.READ_TASK;
            readStandaloneTaskPermission = Permissions.READ;
        }
        this.checkTaskPermission(task, (Permission)((Object)readProcessInstanceTaskPermission), (Permission)((Object)readStandaloneTaskPermission));
    }

    protected void checkTaskPermission(TaskEntity task, Permission processDefinitionPermission, Permission taskPermission) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            ExecutionEntity execution = task.getExecution();
            ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
            CompositePermissionCheck readTaskPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, taskPermission).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), processDefinitionPermission).build();
            this.getAuthorizationManager().checkAuthorization(readTaskPermission);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                this.getAuthorizationManager().checkAuthorization(taskPermission, Resources.TASK, taskId);
            }
        }
    }

    @Override
    public void checkUpdateTaskVariable(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            ExecutionEntity execution = task.getExecution();
            ProcessDefinitionEntity processDefinition = execution.getProcessDefinition();
            CompositePermissionCheck updateTaskPermissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, TaskPermissions.UPDATE_VARIABLE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), ProcessDefinitionPermissions.UPDATE_TASK_VARIABLE).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinition.getKey(), Permissions.UPDATE_TASK).build();
            this.getAuthorizationManager().checkAuthorization(updateTaskPermissionCheck);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                CompositePermissionCheck updateTaskPermissionCheck = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, TaskPermissions.UPDATE_VARIABLE).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).build();
                this.getAuthorizationManager().checkAuthorization(updateTaskPermissionCheck);
            }
        }
    }

    @Override
    public void checkCreateBatch(Permission permission) {
        CompositePermissionCheck createBatchPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.BATCH, null, permission).atomicCheckForResourceId(Resources.BATCH, null, Permissions.CREATE).build();
        this.getAuthorizationManager().checkAuthorization(createBatchPermission);
    }

    @Override
    public void checkDeleteBatch(BatchEntity batch) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE, Resources.BATCH, batch.getId());
    }

    @Override
    public void checkDeleteHistoricBatch(HistoricBatchEntity batch) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.BATCH, batch.getId());
    }

    @Override
    public void checkSuspendBatch(BatchEntity batch) {
        this.getAuthorizationManager().checkAuthorization(Permissions.UPDATE, Resources.BATCH, batch.getId());
    }

    @Override
    public void checkActivateBatch(BatchEntity batch) {
        this.getAuthorizationManager().checkAuthorization(Permissions.UPDATE, Resources.BATCH, batch.getId());
    }

    @Override
    public void checkReadHistoricBatch() {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.BATCH);
    }

    @Override
    public void checkCreateDeployment() {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.DEPLOYMENT);
    }

    @Override
    public void checkReadDeployment(String deploymentId) {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.DEPLOYMENT, deploymentId);
    }

    @Override
    public void checkDeleteDeployment(String deploymentId) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE, Resources.DEPLOYMENT, deploymentId);
    }

    @Override
    public void checkReadDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.DECISION_DEFINITION, decisionDefinition.getKey());
    }

    public void checkUpdateDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.UPDATE, Resources.DECISION_DEFINITION, decisionDefinition.getKey());
    }

    @Override
    public void checkReadDecisionRequirementsDefinition(DecisionRequirementsDefinitionEntity decisionRequirementsDefinition) {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ, Resources.DECISION_REQUIREMENTS_DEFINITION, decisionRequirementsDefinition.getKey());
    }

    @Override
    public void checkReadCaseDefinition(CaseDefinition caseDefinition) {
    }

    @Override
    public void checkUpdateCaseDefinition(CaseDefinition caseDefinition) {
    }

    @Override
    public void checkDeleteHistoricTaskInstance(HistoricTaskInstanceEntity task) {
        if (task != null && task.getProcessDefinitionKey() != null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION, task.getProcessDefinitionKey());
        }
    }

    @Override
    public void checkDeleteHistoricProcessInstance(HistoricProcessInstance instance) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION, instance.getProcessDefinitionKey());
    }

    @Override
    public void checkDeleteHistoricCaseInstance(HistoricCaseInstance instance) {
    }

    @Override
    public void checkDeleteHistoricDecisionInstance(String decisionDefinitionKey) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.DECISION_DEFINITION, decisionDefinitionKey);
    }

    @Override
    public void checkDeleteHistoricDecisionInstance(HistoricDecisionInstance decisionInstance) {
        this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.DECISION_DEFINITION, decisionInstance.getDecisionDefinitionKey());
    }

    @Override
    public void checkReadHistoricJobLog(HistoricJobLogEventEntity historicJobLog) {
        if (historicJobLog.getProcessDefinitionKey() != null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, historicJobLog.getProcessDefinitionKey());
        }
    }

    @Override
    public void checkReadHistoryAnyProcessDefinition() {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, "*");
    }

    @Override
    public void checkReadHistoryProcessDefinition(String processDefinitionKey) {
        this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    @Override
    public void checkUpdateCaseInstance(CaseExecution caseExecution) {
    }

    @Override
    public void checkReadCaseInstance(CaseExecution caseExecution) {
    }

    protected AuthorizationManager getAuthorizationManager() {
        return Context.getCommandContext().getAuthorizationManager();
    }

    protected ProcessDefinitionEntity findLatestProcessDefinitionById(String processDefinitionId) {
        return Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
    }

    protected DecisionDefinitionEntity findLatestDecisionDefinitionById(String decisionDefinitionId) {
        return Context.getCommandContext().getDecisionDefinitionManager().findDecisionDefinitionById(decisionDefinitionId);
    }

    protected ExecutionEntity findExecutionById(String processInstanceId) {
        return Context.getCommandContext().getExecutionManager().findExecutionById(processInstanceId);
    }

    @Override
    public void checkTaskAssign(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            CompositePermissionCheck taskWorkPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, Permissions.TASK_ASSIGN).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, task.getProcessDefinition().getKey(), Permissions.TASK_ASSIGN).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, task.getProcessDefinition().getKey(), Permissions.UPDATE_TASK).build();
            this.getAuthorizationManager().checkAuthorization(taskWorkPermission);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                CompositePermissionCheck taskWorkPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, Permissions.TASK_ASSIGN).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).build();
                this.getAuthorizationManager().checkAuthorization(taskWorkPermission);
            }
        }
    }

    @Override
    public void checkCreateTask(TaskEntity entity) {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.TASK);
    }

    @Override
    public void checkCreateTask() {
        this.getAuthorizationManager().checkAuthorization(Permissions.CREATE, Resources.TASK);
    }

    @Override
    public void checkTaskWork(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            CompositePermissionCheck taskWorkPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, Permissions.TASK_WORK).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, task.getProcessDefinition().getKey(), Permissions.TASK_WORK).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).atomicCheckForResourceId(Resources.PROCESS_DEFINITION, task.getProcessDefinition().getKey(), Permissions.UPDATE_TASK).build();
            this.getAuthorizationManager().checkAuthorization(taskWorkPermission);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                CompositePermissionCheck taskWorkPermission = new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.TASK, taskId, Permissions.TASK_WORK).atomicCheckForResourceId(Resources.TASK, taskId, Permissions.UPDATE).build();
                this.getAuthorizationManager().checkAuthorization(taskWorkPermission);
            }
        }
    }

    @Override
    public void checkDeleteTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        String caseExecutionId = task.getCaseExecutionId();
        if (executionId == null && caseExecutionId == null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.DELETE, Resources.TASK, taskId);
        }
    }

    public void checkUserOperationLog(UserOperationLogEntry entry, ProcessDefinitionPermissions processDefinitionPermission, UserOperationLogCategoryPermissions operationLogCategoryPermission) {
        if (entry != null) {
            String category = entry.getCategory();
            String processDefinitionKey = entry.getProcessDefinitionKey();
            if (category != null || processDefinitionKey != null) {
                CompositePermissionCheck permissionCheck = null;
                permissionCheck = category == null ? new PermissionCheckBuilder().atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinitionKey, processDefinitionPermission).build() : (processDefinitionKey == null ? new PermissionCheckBuilder().atomicCheckForResourceId(Resources.OPERATION_LOG_CATEGORY, category, operationLogCategoryPermission).build() : new PermissionCheckBuilder().disjunctive().atomicCheckForResourceId(Resources.PROCESS_DEFINITION, processDefinitionKey, processDefinitionPermission).atomicCheckForResourceId(Resources.OPERATION_LOG_CATEGORY, category, operationLogCategoryPermission).build());
                this.getAuthorizationManager().checkAuthorization(permissionCheck);
            }
        }
    }

    @Override
    public void checkDeleteUserOperationLog(UserOperationLogEntry entry) {
        this.checkUserOperationLog(entry, ProcessDefinitionPermissions.DELETE_HISTORY, UserOperationLogCategoryPermissions.DELETE);
    }

    @Override
    public void checkUpdateUserOperationLog(UserOperationLogEntry entry) {
        this.checkUserOperationLog(entry, ProcessDefinitionPermissions.UPDATE_HISTORY, UserOperationLogCategoryPermissions.UPDATE);
    }

    @Override
    public void checkReadHistoricExternalTaskLog(HistoricExternalTaskLogEntity historicExternalTaskLog) {
        if (historicExternalTaskLog.getProcessDefinitionKey() != null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, historicExternalTaskLog.getProcessDefinitionKey());
        }
    }

    @Override
    public void checkDeleteHistoricVariableInstance(HistoricVariableInstanceEntity variable) {
        if (variable != null && variable.getProcessDefinitionKey() != null) {
            this.getAuthorizationManager().checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION, variable.getProcessDefinitionKey());
        }
    }

    @Override
    public void checkDeleteHistoricVariableInstancesByProcessInstance(HistoricProcessInstanceEntity instance) {
        this.checkDeleteHistoricProcessInstance(instance);
    }
}

