/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class GetHistoricExternalTaskLogErrorDetailsCmd
implements Command<String> {
    protected String historicExternalTaskLogId;

    public GetHistoricExternalTaskLogErrorDetailsCmd(String historicExternalTaskLogId) {
        this.historicExternalTaskLogId = historicExternalTaskLogId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("historicExternalTaskLogId", (Object)this.historicExternalTaskLogId);
        HistoricExternalTaskLogEntity event = commandContext.getHistoricExternalTaskLogManager().findHistoricExternalTaskLogById(this.historicExternalTaskLogId);
        EnsureUtil.ensureNotNull("No historic external task log found with id " + this.historicExternalTaskLogId, "historicExternalTaskLog", (Object)event);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadHistoricExternalTaskLog(event);
        }
        return event.getErrorDetails();
    }
}

