/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessEngineContextImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandContextFactory;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.CommandInvocationContext;

public class CommandContextInterceptor
extends CommandInterceptor {
    private static final CommandLogger LOG = CommandLogger.CMD_LOGGER;
    protected CommandContextFactory commandContextFactory;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected boolean alwaysOpenNew;

    public CommandContextInterceptor() {
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory, ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.commandContextFactory = commandContextFactory;
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory, ProcessEngineConfigurationImpl processEngineConfiguration, boolean alwaysOpenNew) {
        this(commandContextFactory, processEngineConfiguration);
        this.alwaysOpenNew = alwaysOpenNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        CommandContext existingCommandContext;
        CommandContext context = null;
        if (!this.alwaysOpenNew && (existingCommandContext = Context.getCommandContext()) != null && this.isFromSameEngine(existingCommandContext)) {
            context = existingCommandContext;
        }
        boolean isNew = ProcessEngineContextImpl.consume();
        boolean openNew = context == null || isNew;
        CommandInvocationContext commandInvocationContext = new CommandInvocationContext(command, this.processEngineConfiguration);
        Context.setCommandInvocationContext(commandInvocationContext);
        try {
            if (openNew) {
                LOG.debugOpeningNewCommandContext();
                context = this.commandContextFactory.createCommandContext();
            } else {
                LOG.debugReusingExistingCommandContext();
            }
            Context.setCommandContext(context);
            Context.setProcessEngineConfiguration(this.processEngineConfiguration);
            T t = this.next.execute(command);
            return t;
        }
        catch (Throwable t) {
            commandInvocationContext.trySetThrowable(t);
        }
        finally {
            try {
                if (openNew) {
                    LOG.closingCommandContext();
                    context.close(commandInvocationContext);
                } else {
                    commandInvocationContext.rethrow();
                }
            }
            finally {
                Context.removeCommandInvocationContext();
                Context.removeCommandContext();
                Context.removeProcessEngineConfiguration();
                ProcessEngineContextImpl.set(isNew);
            }
        }
        return null;
    }

    protected boolean isFromSameEngine(CommandContext existingCommandContext) {
        return this.processEngineConfiguration == existingCommandContext.getProcessEngineConfiguration();
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public void setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineContext(ProcessEngineConfigurationImpl processEngineContext) {
        this.processEngineConfiguration = processEngineContext;
    }
}

