/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.deletion;

import java.util.List;
import org.camunda.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobDeclaration;
import org.camunda.bpm.engine.impl.batch.deletion.DeleteHistoricProcessInstanceBatchConfigurationJsonConverter;
import org.camunda.bpm.engine.impl.cmd.DeleteHistoricProcessInstancesCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;

public class DeleteHistoricProcessInstancesJobHandler
extends AbstractBatchJobHandler<BatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("historic-instance-deletion");

    @Override
    public String getType() {
        return "historic-instance-deletion";
    }

    protected DeleteHistoricProcessInstanceBatchConfigurationJsonConverter getJsonConverterInstance() {
        return DeleteHistoricProcessInstanceBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected BatchConfiguration createJobConfiguration(BatchConfiguration configuration, List<String> processIdsForJob) {
        return new BatchConfiguration(processIdsForJob, configuration.isFailIfNotExists());
    }

    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ByteArrayEntity configurationEntity = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, configuration.getConfigurationByteArrayId());
        Object batchConfiguration = this.readConfiguration(configurationEntity.getBytes());
        commandContext.executeWithOperationLogPrevented(new DeleteHistoricProcessInstancesCmd(((BatchConfiguration)batchConfiguration).getIds(), ((BatchConfiguration)batchConfiguration).isFailIfNotExists()));
        commandContext.getByteArrayManager().delete(configurationEntity);
    }
}

