/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Objects;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.cfg.ConfigurationLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.util.ParseUtil;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.model.cmmn.instance.Case;
import org.camunda.bpm.model.dmn.instance.Decision;

public class HistoryTimeToLiveParser {
    protected static final ConfigurationLogger LOG = ConfigurationLogger.CONFIG_LOGGER;
    protected static final int CAMUNDA_MODELER_TTL_DEFAULT_VALUE = 180;
    protected final boolean enforceNonNullValue;
    protected final String httlConfigValue;

    protected HistoryTimeToLiveParser(boolean enforceNonNullValue, String httlConfigValue) {
        this.enforceNonNullValue = enforceNonNullValue;
        this.httlConfigValue = httlConfigValue;
    }

    public static HistoryTimeToLiveParser create() {
        ProcessEngineConfigurationImpl config = Context.getProcessEngineConfiguration();
        Objects.requireNonNull(config, "HistoryTimeToLiveParser requires a non null config to be created");
        return HistoryTimeToLiveParser.create(config);
    }

    public static HistoryTimeToLiveParser create(CommandContext context) {
        ProcessEngineConfigurationImpl config = context.getProcessEngineConfiguration();
        return HistoryTimeToLiveParser.create(config);
    }

    public static HistoryTimeToLiveParser create(ProcessEngineConfigurationImpl config) {
        boolean enforceHistoryTimeToLive = config.isEnforceHistoryTimeToLive();
        String historyTimeToLive = config.getHistoryTimeToLive();
        return new HistoryTimeToLiveParser(enforceHistoryTimeToLive, historyTimeToLive);
    }

    public void validate(Integer historyTimeToLive) {
        if (this.enforceNonNullValue && historyTimeToLive == null) {
            throw new NotAllowedException("Null historyTimeToLive values are not allowed");
        }
    }

    public Integer parse(Element processElement, String definitionKey, boolean skipEnforceTtl) {
        String historyTimeToLiveString = processElement.attributeNS(BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS, "historyTimeToLive");
        return this.parseAndValidate(historyTimeToLiveString, definitionKey, skipEnforceTtl);
    }

    public Integer parse(Case caseElement, String definitionKey, boolean skipEnforceTtl) {
        String historyTimeToLiveString = caseElement.getCamundaHistoryTimeToLiveString();
        return this.parseAndValidate(historyTimeToLiveString, definitionKey, skipEnforceTtl);
    }

    public Integer parse(Decision decision, String definitionKey, boolean skipEnforceTtl) {
        String historyTimeToLiveString = decision.getCamundaHistoryTimeToLiveString();
        return this.parseAndValidate(historyTimeToLiveString, definitionKey, skipEnforceTtl);
    }

    protected Integer parseAndValidate(String historyTimeToLiveString, String definitionKey, boolean skipEnforceTtl) throws NotValidException {
        HTTLParsedResult result = new HTTLParsedResult(historyTimeToLiveString);
        if (!skipEnforceTtl) {
            if (result.isInValidAgainstConfig()) {
                throw new NotValidException("History Time To Live cannot be null");
            }
            if (result.shouldBeLogged()) {
                LOG.logHistoryTimeToLiveDefaultValueWarning(definitionKey);
            }
        }
        return result.valueAsInteger;
    }

    protected class HTTLParsedResult {
        protected final boolean systemDefaultConfigWillBeUsed;
        protected final String value;
        protected final Integer valueAsInteger;

        public HTTLParsedResult(String historyTimeToLiveString) {
            this.systemDefaultConfigWillBeUsed = historyTimeToLiveString == null;
            this.value = this.systemDefaultConfigWillBeUsed ? HistoryTimeToLiveParser.this.httlConfigValue : historyTimeToLiveString;
            this.valueAsInteger = ParseUtil.parseHistoryTimeToLive(this.value);
        }

        protected boolean isInValidAgainstConfig() {
            return HistoryTimeToLiveParser.this.enforceNonNullValue && this.valueAsInteger == null;
        }

        protected boolean shouldBeLogged() {
            return !this.systemDefaultConfigWillBeUsed && this.valueAsInteger != null && this.valueAsInteger == 180;
        }
    }
}

