/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.MigrationObserverBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.Callback;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class ParallelMultiInstanceActivityBehavior
extends MultiInstanceActivityBehavior
implements MigrationObserverBehavior {
    @Override
    protected void createInstances(ActivityExecution execution, int nrOfInstances) throws Exception {
        int i;
        ActivityImpl innerActivity = this.getInnerActivity(execution.getActivity());
        this.prepareScopeExecution(execution, nrOfInstances);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (i = 0; i < nrOfInstances; ++i) {
            concurrentExecutions.add(this.createConcurrentExecution(execution));
        }
        for (i = nrOfInstances - 1; i >= 0; --i) {
            ActivityExecution activityExecution = (ActivityExecution)concurrentExecutions.get(i);
            this.performInstance(activityExecution, innerActivity, i);
        }
    }

    protected void prepareScopeExecution(ActivityExecution scopeExecution, int nrOfInstances) {
        this.setLoopVariable(scopeExecution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(scopeExecution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfInstances);
        scopeExecution.setActivity(null);
        scopeExecution.inactivate();
    }

    protected ActivityExecution createConcurrentExecution(ActivityExecution scopeExecution) {
        ActivityExecution concurrentChild = scopeExecution.createExecution();
        scopeExecution.forceUpdate();
        concurrentChild.setConcurrent(true);
        concurrentChild.setScope(false);
        return concurrentChild;
    }

    @Override
    public void concurrentChildExecutionEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        int nrOfCompletedInstances = this.getLoopVariable(scopeExecution, "nrOfCompletedInstances") + 1;
        this.setLoopVariable(scopeExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        int nrOfActiveInstances = this.getLoopVariable(scopeExecution, "nrOfActiveInstances") - 1;
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfActiveInstances);
        endedExecution.inactivate();
        endedExecution.setActivityInstanceId(null);
        scopeExecution.forceUpdate();
        if (this.completionConditionSatisfied(endedExecution) || this.allExecutionsEnded(scopeExecution, endedExecution)) {
            ArrayList<? extends PvmExecutionImpl> childExecutions = new ArrayList<PvmExecutionImpl>(((PvmExecutionImpl)scopeExecution).getNonEventScopeExecutions());
            for (ActivityExecution activityExecution : childExecutions) {
                if (activityExecution.isActive() || activityExecution.getActivity() == null) {
                    ((PvmExecutionImpl)activityExecution).deleteCascade("Multi instance completion condition satisfied.");
                    continue;
                }
                activityExecution.remove();
            }
            scopeExecution.setActivity((PvmActivity)((Object)endedExecution.getActivity().getFlowScope()));
            scopeExecution.setActive(true);
            this.leave(scopeExecution);
        } else {
            ((ExecutionEntity)scopeExecution).dispatchDelayedEventsAndPerformOperation((Callback<PvmExecutionImpl, Void>)null);
        }
    }

    protected boolean allExecutionsEnded(ActivityExecution scopeExecution, ActivityExecution endedExecution) {
        int numberOfInactiveConcurrentExecutions = endedExecution.findInactiveConcurrentExecutions(endedExecution.getActivity()).size();
        int concurrentExecutions = scopeExecution.getExecutions().size();
        return this.getLocalLoopVariable(scopeExecution, "nrOfActiveInstances") <= 0 && numberOfInactiveConcurrentExecutions == concurrentExecutions;
    }

    @Override
    public void complete(ActivityExecution scopeExecution) {
    }

    @Override
    public List<ActivityExecution> initializeScope(ActivityExecution scopeExecution, int numberOfInstances) {
        this.prepareScopeExecution(scopeExecution, numberOfInstances);
        ArrayList<ActivityExecution> executions = new ArrayList<ActivityExecution>();
        for (int i = 0; i < numberOfInstances; ++i) {
            ActivityExecution concurrentChild = this.createConcurrentExecution(scopeExecution);
            this.setLoopVariable(concurrentChild, "loopCounter", i);
            executions.add(concurrentChild);
        }
        return executions;
    }

    @Override
    public ActivityExecution createInnerInstance(ActivityExecution scopeExecution) {
        ActivityExecution concurrentChild = this.createConcurrentExecution(scopeExecution);
        int nrOfInstances = this.getLoopVariable(scopeExecution, "nrOfInstances");
        this.setLoopVariable(scopeExecution, "nrOfInstances", nrOfInstances + 1);
        int nrOfActiveInstances = this.getLoopVariable(scopeExecution, "nrOfActiveInstances");
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfActiveInstances + 1);
        this.setLoopVariable(concurrentChild, "loopCounter", nrOfInstances);
        return concurrentChild;
    }

    @Override
    public void destroyInnerInstance(ActivityExecution concurrentExecution) {
        ActivityExecution scopeExecution = concurrentExecution.getParent();
        concurrentExecution.remove();
        scopeExecution.forceUpdate();
        int nrOfActiveInstances = this.getLoopVariable(scopeExecution, "nrOfActiveInstances");
        this.setLoopVariable(scopeExecution, "nrOfActiveInstances", nrOfActiveInstances - 1);
    }

    @Override
    public void migrateScope(ActivityExecution scopeExecution) {
        for (ActivityExecution activityExecution : scopeExecution.getExecutions()) {
            if (activityExecution.isActive()) continue;
            ((PvmExecutionImpl)activityExecution).setProcessDefinition(((PvmExecutionImpl)scopeExecution).getProcessDefinition());
        }
    }

    @Override
    public void onParseMigratingInstance(MigratingInstanceParseContext parseContext, MigratingActivityInstance migratingInstance) {
        ExecutionEntity scopeExecution = migratingInstance.resolveRepresentativeExecution();
        List<ActivityExecution> concurrentInActiveExecutions = scopeExecution.findInactiveChildExecutions(this.getInnerActivity((ActivityImpl)migratingInstance.getSourceScope()));
        for (ActivityExecution execution : concurrentInActiveExecutions) {
            for (VariableInstanceEntity variable : ((ExecutionEntity)execution).getVariablesInternal()) {
                parseContext.consume(variable);
            }
        }
    }
}

