/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance;

import org.camunda.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.camunda.bpm.engine.impl.migration.instance.MigratingJobInstance;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class MigratingTimerJobInstance
extends MigratingJobInstance {
    protected ScopeImpl timerTriggerTargetScope;
    protected TimerDeclarationImpl targetJobDeclaration;
    protected boolean updateEvent;

    public MigratingTimerJobInstance(JobEntity jobEntity) {
        super(jobEntity);
    }

    public MigratingTimerJobInstance(JobEntity jobEntity, JobDefinitionEntity jobDefinitionEntity, ScopeImpl targetScope, boolean updateEvent, TimerDeclarationImpl targetTimerDeclaration) {
        super(jobEntity, jobDefinitionEntity, targetScope);
        this.timerTriggerTargetScope = this.determineTimerTriggerTargetScope(jobEntity, targetScope);
        this.updateEvent = updateEvent;
        this.targetJobDeclaration = targetTimerDeclaration;
    }

    protected ScopeImpl determineTimerTriggerTargetScope(JobEntity jobEntity, ScopeImpl targetScope) {
        if ("timer-start-event-subprocess".equals(jobEntity.getJobHandlerType())) {
            return targetScope.getFlowScope();
        }
        return targetScope;
    }

    @Override
    protected void migrateJobHandlerConfiguration() {
        TimerEventJobHandler.TimerJobConfiguration configuration = (TimerEventJobHandler.TimerJobConfiguration)this.jobEntity.getJobHandlerConfiguration();
        configuration.setTimerElementKey(this.timerTriggerTargetScope.getId());
        this.jobEntity.setJobHandlerConfiguration(configuration);
        if (this.updateEvent) {
            this.targetJobDeclaration.updateJob((TimerEntity)this.jobEntity);
        }
    }
}

