/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.junit.rules.ExternalResource;

public abstract class BaseCassandraUnit
extends ExternalResource {
    protected String configurationFileName;
    protected long startupTimeout;

    public BaseCassandraUnit() {
        this(10000L);
    }

    public BaseCassandraUnit(long startupTimeout) {
        this.startupTimeout = startupTimeout;
    }

    protected void before() throws Exception {
        if (this.configurationFileName != null) {
            EmbeddedCassandraServerHelper.startEmbeddedCassandra(this.configurationFileName, this.startupTimeout);
        } else {
            EmbeddedCassandraServerHelper.startEmbeddedCassandra(this.startupTimeout);
        }
        this.load();
    }

    protected abstract void load();
}

