/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ThreadMonitor
implements Runnable {
    private final @UnknownKeyFor @NonNull @Initialized Thread thread;
    private final @UnknownKeyFor @NonNull @Initialized long timeout;

    public static @Nullable @UnknownKeyFor @Initialized Thread start(@UnknownKeyFor @NonNull @Initialized long timeout) {
        return ThreadMonitor.start(Thread.currentThread(), timeout);
    }

    public static @Nullable @UnknownKeyFor @Initialized Thread start(@UnknownKeyFor @NonNull @Initialized Thread thread, @UnknownKeyFor @NonNull @Initialized long timeout) {
        Thread monitor = null;
        if (timeout > 0L) {
            ThreadMonitor timout = new ThreadMonitor(thread, timeout);
            monitor = new Thread((Runnable)timout, ThreadMonitor.class.getSimpleName());
            monitor.setDaemon(true);
            monitor.start();
        }
        return monitor;
    }

    public static void stop(@Nullable @UnknownKeyFor @Initialized Thread thread) {
        if (thread != null) {
            thread.interrupt();
        }
    }

    private ThreadMonitor(@UnknownKeyFor @NonNull @Initialized Thread thread, @UnknownKeyFor @NonNull @Initialized long timeout) {
        this.thread = thread;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        try {
            ThreadMonitor.sleep(this.timeout);
            this.thread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void sleep(@UnknownKeyFor @NonNull @Initialized long ms) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
        long finishAt = System.currentTimeMillis() + ms;
        long remaining = ms;
        do {
            Thread.sleep(remaining);
        } while ((remaining = finishAt - System.currentTimeMillis()) > 0L);
    }
}

