/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.input.ObservableInputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MessageDigestCalculatingInputStream
extends ObservableInputStream {
    private final @UnknownKeyFor @NonNull @Initialized MessageDigest messageDigest;

    public MessageDigestCalculatingInputStream(@UnknownKeyFor @NonNull @Initialized InputStream pStream, @UnknownKeyFor @NonNull @Initialized MessageDigest pDigest) {
        super(pStream);
        this.messageDigest = pDigest;
        this.add(new MessageDigestMaintainingObserver(pDigest));
    }

    public MessageDigestCalculatingInputStream(@UnknownKeyFor @NonNull @Initialized InputStream pStream, @UnknownKeyFor @NonNull @Initialized String pAlgorithm) throws @UnknownKeyFor @NonNull @Initialized NoSuchAlgorithmException {
        this(pStream, MessageDigest.getInstance(pAlgorithm));
    }

    public MessageDigestCalculatingInputStream(@UnknownKeyFor @NonNull @Initialized InputStream pStream) throws @UnknownKeyFor @NonNull @Initialized NoSuchAlgorithmException {
        this(pStream, MessageDigest.getInstance("MD5"));
    }

    public @UnknownKeyFor @NonNull @Initialized MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public static class MessageDigestMaintainingObserver
    extends ObservableInputStream.Observer {
        private final @UnknownKeyFor @NonNull @Initialized MessageDigest md;

        public MessageDigestMaintainingObserver(@UnknownKeyFor @NonNull @Initialized MessageDigest pMd) {
            this.md = pMd;
        }

        @Override
        void data(@UnknownKeyFor @NonNull @Initialized int pByte) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.md.update((byte)pByte);
        }

        @Override
        void data(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] pBuffer, @UnknownKeyFor @NonNull @Initialized int pOffset, @UnknownKeyFor @NonNull @Initialized int pLength) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.md.update(pBuffer, pOffset, pLength);
        }
    }
}

