/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.MessageDigestCalculatingInputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ObservableInputStream
extends ProxyInputStream {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Observer> observers = new ArrayList<Observer>();

    public ObservableInputStream(@UnknownKeyFor @NonNull @Initialized InputStream pProxy) {
        super(pProxy);
    }

    public void add(@UnderInitialization(value=MessageDigestCalculatingInputStream.class) ObservableInputStream this, @UnknownKeyFor @NonNull @Initialized Observer pObserver) {
        this.observers.add(pObserver);
    }

    public void remove(@UnknownKeyFor @NonNull @Initialized Observer pObserver) {
        this.observers.remove(pObserver);
    }

    public void removeAllObservers() {
        this.observers.clear();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        int result = 0;
        IOException ioe = null;
        try {
            result = super.read();
        }
        catch (IOException pException) {
            ioe = pException;
        }
        if (ioe != null) {
            this.noteError(ioe);
        } else if (result == -1) {
            this.noteFinished();
        } else {
            this.noteDataByte(result);
        }
        return result;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] pBuffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int result = 0;
        IOException ioe = null;
        try {
            result = super.read(pBuffer);
        }
        catch (IOException pException) {
            ioe = pException;
        }
        if (ioe != null) {
            this.noteError(ioe);
        } else if (result == -1) {
            this.noteFinished();
        } else if (result > 0) {
            this.noteDataBytes(pBuffer, 0, result);
        }
        return result;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] pBuffer, @UnknownKeyFor @NonNull @Initialized int pOffset, @UnknownKeyFor @NonNull @Initialized int pLength) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int result = 0;
        IOException ioe = null;
        try {
            result = super.read(pBuffer, pOffset, pLength);
        }
        catch (IOException pException) {
            ioe = pException;
        }
        if (ioe != null) {
            this.noteError(ioe);
        } else if (result == -1) {
            this.noteFinished();
        } else if (result > 0) {
            this.noteDataBytes(pBuffer, pOffset, result);
        }
        return result;
    }

    protected void noteDataBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] pBuffer, @UnknownKeyFor @NonNull @Initialized int pOffset, @UnknownKeyFor @NonNull @Initialized int pLength) throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (Observer observer : this.getObservers()) {
            observer.data(pBuffer, pOffset, pLength);
        }
    }

    protected void noteFinished() throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (Observer observer : this.getObservers()) {
            observer.finished();
        }
    }

    protected void noteDataByte(@UnknownKeyFor @NonNull @Initialized int pDataByte) throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (Observer observer : this.getObservers()) {
            observer.data(pDataByte);
        }
    }

    protected void noteError(@UnknownKeyFor @NonNull @Initialized IOException pException) throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (Observer observer : this.getObservers()) {
            observer.error(pException);
        }
    }

    protected void noteClosed() throws @UnknownKeyFor @NonNull @Initialized IOException {
        for (Observer observer : this.getObservers()) {
            observer.closed();
        }
    }

    protected @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Observer> getObservers() {
        return this.observers;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOException ioe = null;
        try {
            super.close();
        }
        catch (IOException e) {
            ioe = e;
        }
        if (ioe == null) {
            this.noteClosed();
        } else {
            this.noteError(ioe);
        }
    }

    public void consume() throws @UnknownKeyFor @NonNull @Initialized IOException {
        int res;
        byte[] buffer = new byte[8192];
        while ((res = this.read(buffer)) != -1) {
        }
    }

    public static abstract class Observer {
        void data(@UnknownKeyFor @NonNull @Initialized int pByte) throws @UnknownKeyFor @NonNull @Initialized IOException {
        }

        void data(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] pBuffer, @UnknownKeyFor @NonNull @Initialized int pOffset, @UnknownKeyFor @NonNull @Initialized int pLength) throws @UnknownKeyFor @NonNull @Initialized IOException {
        }

        void finished() throws @UnknownKeyFor @NonNull @Initialized IOException {
        }

        void closed() throws @UnknownKeyFor @NonNull @Initialized IOException {
        }

        void error(@UnknownKeyFor @NonNull @Initialized IOException pException) throws @UnknownKeyFor @NonNull @Initialized IOException {
            throw pException;
        }
    }
}

