/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class ProxyInputStream
extends FilterInputStream {
    public ProxyInputStream(@UnknownKeyFor @NonNull @Initialized InputStream proxy) {
        super(proxy);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeRead(1);
            int b = this.in.read();
            this.afterRead(b != -1 ? 1 : -1);
            return b;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bts) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeRead(bts != null ? bts.length : 0);
            int n = this.in.read(bts);
            this.afterRead(n);
            return n;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bts, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeRead(len);
            int n = this.in.read(bts, off, len);
            this.afterRead(n);
            return n;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized long ln) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return this.in.skip(ln);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return 0L;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int available() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return super.available();
        }
        catch (IOException e) {
            this.handleIOException(e);
            return 0;
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.in.close();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public synchronized void mark(@UnknownKeyFor @NonNull @Initialized int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.in.reset();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean markSupported() {
        return this.in.markSupported();
    }

    protected void beforeRead(@UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void afterRead(@UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void handleIOException(@UnknownKeyFor @NonNull @Initialized IOException e) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw e;
    }
}

