/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.XmlStreamReader;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class XmlStreamWriter
extends Writer {
    private static final @UnknownKeyFor @NonNull @Initialized int BUFFER_SIZE = 4096;
    private final @UnknownKeyFor @NonNull @Initialized OutputStream out;
    private final @UnknownKeyFor @NonNull @Initialized String defaultEncoding;
    private @Nullable @UnknownKeyFor @Initialized StringWriter xmlPrologWriter = new StringWriter(4096);
    private @MonotonicNonNull @UnknownKeyFor @Initialized Writer writer;
    private @MonotonicNonNull @UnknownKeyFor @Initialized String encoding;
    static final @UnknownKeyFor @NonNull @Initialized Pattern ENCODING_PATTERN = XmlStreamReader.ENCODING_PATTERN;

    public XmlStreamWriter(@UnknownKeyFor @NonNull @Initialized OutputStream out) {
        this(out, null);
    }

    public XmlStreamWriter(@UnknownKeyFor @NonNull @Initialized OutputStream out, @Nullable @UnknownKeyFor @Initialized String defaultEncoding) {
        this.out = out;
        this.defaultEncoding = defaultEncoding != null ? defaultEncoding : "UTF-8";
    }

    public XmlStreamWriter(@UnknownKeyFor @NonNull @Initialized File file) throws @UnknownKeyFor @NonNull @Initialized FileNotFoundException {
        this(file, null);
    }

    public XmlStreamWriter(@UnknownKeyFor @NonNull @Initialized File file, @Nullable @UnknownKeyFor @Initialized String defaultEncoding) throws @UnknownKeyFor @NonNull @Initialized FileNotFoundException {
        this(new FileOutputStream(file), defaultEncoding);
    }

    public @Nullable @UnknownKeyFor @Initialized String getEncoding() {
        return this.encoding;
    }

    public @UnknownKeyFor @NonNull @Initialized String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    @EnsuresNonNull(value={"writer"})
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.writer == null) {
            assert (this.xmlPrologWriter != null) : "@AssumeAssertion(nullness): At least one of xmlPrologWriter and writer is non-null";
            this.encoding = this.defaultEncoding;
            this.writer = new OutputStreamWriter(this.out, this.encoding);
            this.writer.write(this.xmlPrologWriter.toString());
        }
        this.writer.close();
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @RequiresNonNull(value={"xmlPrologWriter"})
    private void detectEncoding(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int size = len;
        StringBuffer xmlProlog = this.xmlPrologWriter.getBuffer();
        if (xmlProlog.length() + len > 4096) {
            size = 4096 - xmlProlog.length();
        }
        this.xmlPrologWriter.write(cbuf, off, size);
        if (xmlProlog.length() >= 5) {
            if (xmlProlog.substring(0, 5).equals("<?xml")) {
                int xmlPrologEnd = xmlProlog.indexOf("?>");
                if (xmlPrologEnd > 0) {
                    Matcher m = ENCODING_PATTERN.matcher(xmlProlog.substring(0, xmlPrologEnd));
                    if (m.find()) {
                        this.encoding = m.group(1).toUpperCase();
                        this.encoding = this.encoding.substring(1, this.encoding.length() - 1);
                    } else {
                        this.encoding = this.defaultEncoding;
                    }
                } else if (xmlProlog.length() >= 4096) {
                    this.encoding = this.defaultEncoding;
                }
            } else {
                this.encoding = this.defaultEncoding;
            }
            if (this.encoding != null) {
                this.xmlPrologWriter = null;
                this.writer = new OutputStreamWriter(this.out, this.encoding);
                this.writer.write(xmlProlog.toString());
                if (len > size) {
                    this.writer.write(cbuf, off + size, len - size);
                }
            }
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.xmlPrologWriter != null) {
            this.detectEncoding(cbuf, off, len);
        } else {
            this.writer.write(cbuf, off, len);
        }
    }
}

