/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CleaningPathVisitor
extends CountingPathVisitor {
    private final @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] skip;

    public static @UnknownKeyFor @NonNull @Initialized CountingPathVisitor withBigIntegerCounters() {
        return new CleaningPathVisitor(Counters.bigIntegerPathCounters(), new String[0]);
    }

    public static @UnknownKeyFor @NonNull @Initialized CountingPathVisitor withLongCounters() {
        return new CleaningPathVisitor(Counters.longPathCounters(), new String[0]);
    }

    public CleaningPathVisitor(@UnknownKeyFor @NonNull @Initialized Counters.PathCounters pathCounter, String ... skip) {
        super(pathCounter);
        Object[] temp = skip != null ? (String[])skip.clone() : EMPTY_STRING_ARRAY;
        Arrays.sort(temp);
        this.skip = temp;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean accept(@UnknownKeyFor @NonNull @Initialized Path path) {
        return Arrays.binarySearch(this.skip, Objects.toString(path.getFileName(), null)) < 0;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileVisitResult preVisitDirectory(@UnknownKeyFor @NonNull @Initialized Path dir, @UnknownKeyFor @NonNull @Initialized BasicFileAttributes attributes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        super.preVisitDirectory(dir, attributes);
        return this.accept(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FileVisitResult visitFile(@UnknownKeyFor @NonNull @Initialized Path file, @UnknownKeyFor @NonNull @Initialized BasicFileAttributes attributes) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.accept(file) && Files.exists(file, new LinkOption[0])) {
            Files.deleteIfExists(file);
        }
        this.updateFileCounters(file, attributes);
        return FileVisitResult.CONTINUE;
    }
}

