/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Tailer
implements Runnable {
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_DELAY_MILLIS = 1000;
    private static final @UnknownKeyFor @NonNull @Initialized String RAF_MODE = "r";
    private static final @UnknownKeyFor @NonNull @Initialized Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] inbuf;
    private final @UnknownKeyFor @NonNull @Initialized File file;
    private final @UnknownKeyFor @NonNull @Initialized Charset charset;
    private final @UnknownKeyFor @NonNull @Initialized long delayMillis;
    private final @UnknownKeyFor @NonNull @Initialized boolean end;
    private final @UnknownKeyFor @NonNull @Initialized TailerListener listener;
    private final @UnknownKeyFor @NonNull @Initialized boolean reOpen;
    private volatile @UnknownKeyFor @NonNull @Initialized boolean run = true;

    public Tailer(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener) {
        this(file, listener, 1000L);
    }

    public Tailer(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis) {
        this(file, listener, delayMillis, false);
    }

    public Tailer(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end) {
        this(file, listener, delayMillis, end, 8192);
    }

    public Tailer(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end, @UnknownKeyFor @NonNull @Initialized boolean reOpen) {
        this(file, listener, delayMillis, end, reOpen, 8192);
    }

    public Tailer(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end, @UnknownKeyFor @NonNull @Initialized int bufSize) {
        this(file, listener, delayMillis, end, false, bufSize);
    }

    public Tailer(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end, @UnknownKeyFor @NonNull @Initialized boolean reOpen, @UnknownKeyFor @NonNull @Initialized int bufSize) {
        this(file, DEFAULT_CHARSET, listener, delayMillis, end, reOpen, bufSize);
    }

    public Tailer(@UnknownKeyFor @NonNull @Initialized File file, @NonNull @UnknownKeyFor @Initialized Charset charset, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end, @UnknownKeyFor @NonNull @Initialized boolean reOpen, @UnknownKeyFor @NonNull @Initialized int bufSize) {
        this.file = file;
        this.delayMillis = delayMillis;
        this.end = end;
        this.inbuf = new byte[bufSize];
        this.listener = listener;
        listener.init(this);
        this.reOpen = reOpen;
        this.charset = charset;
    }

    public static @UnknownKeyFor @NonNull @Initialized Tailer create(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end, @UnknownKeyFor @NonNull @Initialized int bufSize) {
        return Tailer.create(file, listener, delayMillis, end, false, bufSize);
    }

    public static @UnknownKeyFor @NonNull @Initialized Tailer create(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end, @UnknownKeyFor @NonNull @Initialized boolean reOpen, @UnknownKeyFor @NonNull @Initialized int bufSize) {
        return Tailer.create(file, DEFAULT_CHARSET, listener, delayMillis, end, reOpen, bufSize);
    }

    public static @UnknownKeyFor @NonNull @Initialized Tailer create(@UnknownKeyFor @NonNull @Initialized File file, @NonNull @UnknownKeyFor @Initialized Charset charset, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end, @UnknownKeyFor @NonNull @Initialized boolean reOpen, @UnknownKeyFor @NonNull @Initialized int bufSize) {
        Tailer tailer = new Tailer(file, charset, listener, delayMillis, end, reOpen, bufSize);
        Thread thread = new Thread(tailer);
        thread.setDaemon(true);
        thread.start();
        return tailer;
    }

    public static @UnknownKeyFor @NonNull @Initialized Tailer create(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end) {
        return Tailer.create(file, listener, delayMillis, end, 8192);
    }

    public static @UnknownKeyFor @NonNull @Initialized Tailer create(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis, @UnknownKeyFor @NonNull @Initialized boolean end, @UnknownKeyFor @NonNull @Initialized boolean reOpen) {
        return Tailer.create(file, listener, delayMillis, end, reOpen, 8192);
    }

    public static @UnknownKeyFor @NonNull @Initialized Tailer create(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener, @UnknownKeyFor @NonNull @Initialized long delayMillis) {
        return Tailer.create(file, listener, delayMillis, false);
    }

    public static @UnknownKeyFor @NonNull @Initialized Tailer create(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized TailerListener listener) {
        return Tailer.create(file, listener, 1000L, false);
    }

    public @UnknownKeyFor @NonNull @Initialized File getFile() {
        return this.file;
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean getRun() {
        return this.run;
    }

    public @UnknownKeyFor @NonNull @Initialized long getDelay() {
        return this.delayMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RandomAccessFile reader = null;
        try {
            long last = 0L;
            long position = 0L;
            while (this.getRun() && reader == null) {
                try {
                    reader = new RandomAccessFile(this.file, RAF_MODE);
                }
                catch (FileNotFoundException e) {
                    this.listener.fileNotFound();
                }
                if (reader == null) {
                    Thread.sleep(this.delayMillis);
                    continue;
                }
                position = this.end ? this.file.length() : 0L;
                last = this.file.lastModified();
                reader.seek(position);
            }
            while (this.getRun()) {
                assert (reader != null) : "@AssumeAssertion(nullness):  first while loop terminates if reader is non-null or the Tailer thread stops; if thread stops, it is never restarted and this while loop is not executed";
                boolean newer = FileUtils.isFileNewer(this.file, last);
                long length = this.file.length();
                if (length < position) {
                    this.listener.fileRotated();
                    try {
                        RandomAccessFile save = reader;
                        Throwable throwable = null;
                        try {
                            reader = new RandomAccessFile(this.file, RAF_MODE);
                            try {
                                this.readLines(save);
                            }
                            catch (IOException ioe) {
                                this.listener.handle(ioe);
                            }
                            position = 0L;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (save == null) continue;
                            Tailer.$closeResource(throwable, save);
                        }
                    }
                    catch (FileNotFoundException e) {
                        this.listener.fileNotFound();
                        Thread.sleep(this.delayMillis);
                    }
                    continue;
                }
                if (length > position) {
                    position = this.readLines(reader);
                    last = this.file.lastModified();
                } else if (newer) {
                    position = 0L;
                    reader.seek(position);
                    position = this.readLines(reader);
                    last = this.file.lastModified();
                }
                if (this.reOpen && reader != null) {
                    reader.close();
                }
                Thread.sleep(this.delayMillis);
                if (!this.getRun() || !this.reOpen) continue;
                reader = new RandomAccessFile(this.file, RAF_MODE);
                reader.seek(position);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.listener.handle(e);
        }
        catch (Exception e) {
            this.listener.handle(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.listener.handle(e);
            }
            this.stop();
        }
    }

    public void stop() {
        this.run = false;
    }

    private @UnknownKeyFor @NonNull @Initialized long readLines(@UnknownKeyFor @NonNull @Initialized RandomAccessFile reader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (ByteArrayOutputStream lineBuf = new ByteArrayOutputStream(64);){
            int num;
            long pos;
            long rePos = pos = reader.getFilePointer();
            boolean seenCR = false;
            while (this.getRun() && (num = reader.read(this.inbuf)) != -1) {
                block10: for (int i = 0; i < num; ++i) {
                    byte ch = this.inbuf[i];
                    switch (ch) {
                        case 10: {
                            seenCR = false;
                            this.listener.handle(new String(lineBuf.toByteArray(), this.charset));
                            lineBuf.reset();
                            rePos = pos + (long)i + 1L;
                            continue block10;
                        }
                        case 13: {
                            if (seenCR) {
                                lineBuf.write(13);
                            }
                            seenCR = true;
                            continue block10;
                        }
                        default: {
                            if (seenCR) {
                                seenCR = false;
                                this.listener.handle(new String(lineBuf.toByteArray(), this.charset));
                                lineBuf.reset();
                                rePos = pos + (long)i + 1L;
                            }
                            lineBuf.write(ch);
                        }
                    }
                }
                pos = reader.getFilePointer();
            }
            reader.seek(rePos);
            if (this.listener instanceof TailerListenerAdapter) {
                ((TailerListenerAdapter)this.listener).endOfFileReached();
            }
            long l = rePos;
            return l;
        }
    }
}

