/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.input.buffer.CircularBufferInputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PeekableInputStream
extends CircularBufferInputStream {
    public PeekableInputStream(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @UnknownKeyFor @NonNull @Initialized int bufferSize) {
        super(inputStream, bufferSize);
    }

    public PeekableInputStream(@UnknownKeyFor @NonNull @Initialized InputStream inputStream) {
        super(inputStream);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean peek(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] sourceBuffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(sourceBuffer, "Buffer");
        if (sourceBuffer.length > this.bufferSize) {
            throw new IllegalArgumentException("Peek request size of " + sourceBuffer.length + " bytes exceeds buffer size of " + this.bufferSize + " bytes");
        }
        if (this.buffer.getCurrentNumberOfBytes() < sourceBuffer.length) {
            this.fillBuffer();
        }
        return this.buffer.peek(sourceBuffer, 0, sourceBuffer.length);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean peek(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] sourceBuffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(sourceBuffer, "Buffer");
        if (sourceBuffer.length > this.bufferSize) {
            throw new IllegalArgumentException("Peek request size of " + sourceBuffer.length + " bytes exceeds buffer size of " + this.bufferSize + " bytes");
        }
        if (this.buffer.getCurrentNumberOfBytes() < sourceBuffer.length) {
            this.fillBuffer();
        }
        return this.buffer.peek(sourceBuffer, offset, length);
    }
}

