/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.File;
import java.io.Serializable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FileEntry
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -2505664948818681153L;
    static final @UnknownKeyFor @NonNull @Initialized FileEntry @UnknownKeyFor @NonNull @Initialized [] EMPTY_ENTRIES = new FileEntry[0];
    private final @Nullable @UnknownKeyFor @Initialized FileEntry parent;
    private @UnknownKeyFor @NonNull @Initialized FileEntry @Nullable @UnknownKeyFor @Initialized [] children;
    private final @UnknownKeyFor @NonNull @Initialized File file;
    private @UnknownKeyFor @NonNull @Initialized String name;
    private @UnknownKeyFor @NonNull @Initialized boolean exists;
    private @UnknownKeyFor @NonNull @Initialized boolean directory;
    private @UnknownKeyFor @NonNull @Initialized long lastModified;
    private @UnknownKeyFor @NonNull @Initialized long length;

    public FileEntry(@UnknownKeyFor @NonNull @Initialized File file) {
        this(null, file);
    }

    public FileEntry(@Nullable @UnknownKeyFor @Initialized FileEntry parent, @UnknownKeyFor @NonNull @Initialized File file) {
        if (file == null) {
            throw new IllegalArgumentException("File is missing");
        }
        this.file = file;
        this.parent = parent;
        this.name = file.getName();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean refresh(@UnknownKeyFor @NonNull @Initialized File file) {
        boolean origExists = this.exists;
        long origLastModified = this.lastModified;
        boolean origDirectory = this.directory;
        long origLength = this.length;
        this.name = file.getName();
        this.exists = file.exists();
        this.directory = this.exists && file.isDirectory();
        this.lastModified = this.exists ? file.lastModified() : 0L;
        this.length = this.exists && !this.directory ? file.length() : 0L;
        return this.exists != origExists || this.lastModified != origLastModified || this.directory != origDirectory || this.length != origLength;
    }

    public @UnknownKeyFor @NonNull @Initialized FileEntry newChildInstance(@UnknownKeyFor @NonNull @Initialized File file) {
        return new FileEntry(this, file);
    }

    public @Nullable @UnknownKeyFor @Initialized FileEntry getParent() {
        return this.parent;
    }

    public @UnknownKeyFor @NonNull @Initialized int getLevel() {
        return this.parent == null ? 0 : this.parent.getLevel() + 1;
    }

    public @UnknownKeyFor @NonNull @Initialized FileEntry @UnknownKeyFor @NonNull @Initialized [] getChildren() {
        return this.children != null ? this.children : EMPTY_ENTRIES;
    }

    public void setChildren(FileEntry ... children) {
        this.children = children;
    }

    public @UnknownKeyFor @NonNull @Initialized File getFile() {
        return this.file;
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    public void setName(@UnknownKeyFor @NonNull @Initialized String name) {
        this.name = name;
    }

    public @UnknownKeyFor @NonNull @Initialized long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(@UnknownKeyFor @NonNull @Initialized long lastModified) {
        this.lastModified = lastModified;
    }

    public @UnknownKeyFor @NonNull @Initialized long getLength() {
        return this.length;
    }

    public void setLength(@UnknownKeyFor @NonNull @Initialized long length) {
        this.length = length;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isExists() {
        return this.exists;
    }

    public void setExists(@UnknownKeyFor @NonNull @Initialized boolean exists) {
        this.exists = exists;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(@UnknownKeyFor @NonNull @Initialized boolean directory) {
        this.directory = directory;
    }
}

