/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.client;

import java.net.URI;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.util.ObjectHelper;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public class BasicAuthClientHttpRequestFactory
implements FactoryBean<HttpComponentsClientHttpRequestFactory>,
InitializingPhase {
    private HttpClientBuilder httpClient;
    private Credentials credentials;
    private AuthScope authScope = new AuthScope(new HttpHost("http", "localhost", 8080));

    public HttpComponentsClientHttpRequestFactory getObject() throws Exception {
        ObjectHelper.assertNotNull((Object)this.credentials, (String)"User credentials not set properly!");
        return new HttpComponentsClientHttpRequestFactory((HttpClient)this.httpClient.build()){

            protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                basicAuth.initPreemptive(BasicAuthClientHttpRequestFactory.this.credentials);
                HttpHost httpTarget = new HttpHost(uri.getScheme(), BasicAuthClientHttpRequestFactory.this.authScope.getHost(), BasicAuthClientHttpRequestFactory.this.authScope.getPort());
                authCache.put(httpTarget, (AuthScheme)basicAuth);
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(httpTarget), BasicAuthClientHttpRequestFactory.this.credentials);
                HttpClientContext httpClientContext = HttpClientContext.create();
                httpClientContext.setAuthCache((AuthCache)authCache);
                httpClientContext.setCredentialsProvider((CredentialsProvider)credentialsProvider);
                return httpClientContext;
            }
        };
    }

    public Class<?> getObjectType() {
        return HttpComponentsClientHttpRequestFactory.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void initialize() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(this.authScope, this.credentials);
        if (this.httpClient == null) {
            this.httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        } else {
            this.httpClient.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setAuthScope(AuthScope authScope) {
        this.authScope = authScope;
    }

    public void setHttpClient(HttpClientBuilder httpClient) {
        this.httpClient = httpClient;
    }
}

