/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.client;

import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.AbstractEndpointComponent;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.http.client.HttpEndpointConfiguration;
import org.citrusframework.message.ErrorHandlingStrategy;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpEndpointComponent
extends AbstractEndpointComponent {
    public HttpEndpointComponent() {
        this("http");
    }

    public HttpEndpointComponent(String name) {
        super(name);
    }

    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        HttpClient client = new HttpClient();
        client.getEndpointConfiguration().setRequestUrl(this.getScheme() + resourcePath + this.getParameterString(parameters, HttpEndpointConfiguration.class));
        if (parameters.containsKey("requestMethod")) {
            String method = parameters.remove("requestMethod");
            client.getEndpointConfiguration().setRequestMethod(RequestMethod.valueOf((String)method));
        }
        if (parameters.containsKey("errorHandlingStrategy")) {
            String strategy = parameters.remove("errorHandlingStrategy");
            client.getEndpointConfiguration().setErrorHandlingStrategy(ErrorHandlingStrategy.fromName((String)strategy));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)client.getEndpointConfiguration(), this.getEndpointConfigurationParameters(parameters, HttpEndpointConfiguration.class), context);
        return client;
    }

    protected String getScheme() {
        return "http://";
    }
}

