/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.tools.daemon;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.cargo.tools.daemon.MultipartFormContentType;

public class MultipartFormWriter {
    private static final String NEWLINE = "\r\n";
    private static final String PREFIX = "--";
    private DataOutputStream out = null;
    private String boundary = null;

    public MultipartFormWriter(MultipartFormContentType contentType, OutputStream os) {
        if (os == null) {
            throw new IllegalArgumentException("Output stream is required.");
        }
        this.out = new DataOutputStream(os);
        this.boundary = contentType.getBoundary();
    }

    public void writeField(String name, String value) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"");
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes(NEWLINE);
        if (value != null) {
            this.out.writeBytes(value);
        }
        this.out.writeBytes(NEWLINE);
        this.out.flush();
    }

    public void writeFile(String name, String mimeType, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File cannot be a directory.");
        }
        this.writeFile(name, mimeType, file.getCanonicalPath(), new FileInputStream(file));
    }

    public void writeFile(String name, String mimeType, String fileName, InputStream is) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("Input stream cannot be null.");
        }
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"");
        this.out.writeBytes(NEWLINE);
        if (mimeType != null) {
            this.out.writeBytes("Content-Type: " + mimeType);
            this.out.writeBytes(NEWLINE);
        }
        this.out.writeBytes(NEWLINE);
        byte[] data = new byte[1024];
        int r = 0;
        while ((r = is.read(data, 0, data.length)) != -1) {
            this.out.write(data, 0, r);
        }
        is.close();
        this.out.writeBytes(NEWLINE);
        this.out.flush();
    }

    public void writeFile(String name, String mimeType, String fileName, byte[] data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("File name cannot be null or empty.");
        }
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(NEWLINE);
        this.out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"");
        this.out.writeBytes(NEWLINE);
        if (mimeType != null) {
            this.out.writeBytes("Content-Type: " + mimeType);
            this.out.writeBytes(NEWLINE);
        }
        this.out.writeBytes(NEWLINE);
        this.out.write(data, 0, data.length);
        this.out.writeBytes(NEWLINE);
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(this.boundary);
        this.out.writeBytes(PREFIX);
        this.out.writeBytes(NEWLINE);
        this.out.flush();
        this.out.close();
    }
}

