/*
 * Copyright (C) 2006-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.codehaus.gmaven.plugin.execute;

import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

/**
 * Container for <tt>groovy:execute</tt> source configuration.
 *
 * @version $Id: Source.java 88 2009-12-11 11:04:25Z user57 $
 * @author <a href="mailto:jason@planet57.com">Jason Dillon</a>
 */
public class Source
{
    public final PlexusConfiguration configuration;

    public final ExpressionEvaluator evaluator;

    public Source(final PlexusConfiguration configuration, final ExpressionEvaluator evaluator) {
        assert configuration != null;
        assert evaluator != null;

        this.configuration = configuration;
        this.evaluator = evaluator;
    }

    public String toString() {
        return configuration.toString();
    }
}