package org.codehaus.gmaven.plugin.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on gmaven-plugin.<br/> Call <pre>  mvn groovy:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Dec 06 17:38:40 PST 2012
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.9)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.gmaven:gmaven-plugin:1.5", 0 );
        append( sb, "", 0 );

        append( sb, "GMaven Plugin", 0 );
        append( sb, "Provides support for execution, compilation and other facets of Groovy development.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 10 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "addSource".equals( goal ) )
        {
            append( sb, "groovy:addSource", 0 );
            append( sb, "Add source directories to the Maven project.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "sources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "testSources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "compile".equals( goal ) )
        {
            append( sb, "groovy:compile", 0 );
            append( sb, "Compiles Groovy sources.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classpath", 2 );
                append( sb, "Additional artifacts to add to the classpath (in addition to the classpath which is picked up from the executing poms configuration).", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Turns debugging operation on or off.", 3 );
                append( sb, "Expression: ${debug}", 3 );
                append( sb, "", 0 );

                append( sb, "defaultScriptExtension (Default: .groovy)", 2 );
                append( sb, "Set the default extention for Groovy script source files.", 3 );
                append( sb, "Expression: ${defaultScriptExtension}", 3 );
                append( sb, "", 0 );

                append( sb, "invokeDynamic (Default: false)", 2 );
                append( sb, "Allow setting whether to support invokeDynamic (requires Java 7 or greater).", 3 );
                append( sb, "Expression: ${invokeDynamic}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "The directory where generated Java class files will be placed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "providerSelection", 2 );
                append( sb, "A comma-separated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3 );
                append( sb, "Expression: ${gmaven.runtime}", 3 );
                append( sb, "", 0 );

                append( sb, "scriptBaseClassname", 2 );
                append( sb, "Sets the name of the base class for scripts. It must be a subclass of groovy.lang.Script.", 3 );
                append( sb, "Expression: ${scriptBaseClassname}", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Sets the encoding to be used when reading source files.", 3 );
                append( sb, "Expression: ${sourceEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "sources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "stacktrace (Default: false)", 2 );
                append( sb, "Enable compiler to report stack trace information if a problem occurs.", 3 );
                append( sb, "Expression: ${stacktrace}", 3 );
                append( sb, "", 0 );

                append( sb, "targetBytecode", 2 );
                append( sb, "Allow setting the bytecode compatibility.", 3 );
                append( sb, "Expression: ${targetBytecode}", 3 );
                append( sb, "", 0 );

                append( sb, "testSources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "tolerance (Default: 0)", 2 );
                append( sb, "Sets the error tolerance, which is the number of non-fatal errors (per unit) that should be tolerated before compilation is aborted.", 3 );
                append( sb, "Expression: ${tolerance}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Turns verbose operation on or off.", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "console".equals( goal ) )
        {
            append( sb, "groovy:console", 0 );
            append( sb, "Launches the Groovy GUI console.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "providerSelection", 2 );
                append( sb, "A comma-separated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3 );
                append( sb, "Expression: ${gmaven.runtime}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "execute".equals( goal ) )
        {
            append( sb, "groovy:execute", 0 );
            append( sb, "Executes a Groovy script.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classpath", 2 );
                append( sb, "Additional artifacts to add to the scripts classpath.", 3 );
                append( sb, "", 0 );

                append( sb, "classpathIncludes (Default: all)", 2 );
                append( sb, "Allows control over what classpath elements are included. Comma separated list which can contain one or more of: all, runtime, artifacts, plugins, none.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "defaults", 2 );
                append( sb, "A set of default project properties, which the values will be used only if the project or system does not override.", 3 );
                append( sb, "", 0 );

                append( sb, "properties", 2 );
                append( sb, "A set of additional project properties.", 3 );
                append( sb, "", 0 );

                append( sb, "providerSelection", 2 );
                append( sb, "A comma-separated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3 );
                append( sb, "Expression: ${gmaven.runtime}", 3 );
                append( sb, "", 0 );

                append( sb, "sanitizeErrors (Default: true)", 2 );
                append( sb, "Sanatize errors, stripping out Groovy internals.", 3 );
                append( sb, "", 0 );

                append( sb, "scriptpath", 2 );
                append( sb, "Path to search for imported scripts.", 3 );
                append( sb, "", 0 );

                append( sb, "source", 2 );
                append( sb, "The source of the script to execute. This can be a URL, File or script body.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "trapAssertionErrors (Default: true)", 2 );
                append( sb, "Trap assertion errors and rethrow them as execution failures.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generateStubs".equals( goal ) )
        {
            append( sb, "groovy:generateStubs", 0 );
            append( sb, "Generate Java stubs from Groovy sources.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classpath", 2 );
                append( sb, "Additional artifacts to add to the classpath (in addition to the classpath which is picked up from the executing poms configuration).", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/groovy-stubs/main)", 2 );
                append( sb, "The directory where generated Java stub files will be placed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "providerSelection", 2 );
                append( sb, "A comma-separated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3 );
                append( sb, "Expression: ${gmaven.runtime}", 3 );
                append( sb, "", 0 );

                append( sb, "sources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "testSources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generateTestStubs".equals( goal ) )
        {
            append( sb, "groovy:generateTestStubs", 0 );
            append( sb, "Generate Java stubs from Groovy test sources.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classpath", 2 );
                append( sb, "Additional artifacts to add to the classpath (in addition to the classpath which is picked up from the executing poms configuration).", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/groovy-stubs/test)", 2 );
                append( sb, "The directory where generated Java stub files will be placed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "providerSelection", 2 );
                append( sb, "A comma-separated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3 );
                append( sb, "Expression: ${gmaven.runtime}", 3 );
                append( sb, "", 0 );

                append( sb, "sources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "testSources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "groovy:help", 0 );
            append( sb, "Display help information on gmaven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0groovy:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "providers".equals( goal ) )
        {
            append( sb, "groovy:providers", 0 );
            append( sb, "Displays information about the Groovy runtime providers which are configured and selected.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "providerSelection", 2 );
                append( sb, "A comma-separated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3 );
                append( sb, "Expression: ${gmaven.runtime}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "shell".equals( goal ) )
        {
            append( sb, "groovy:shell", 0 );
            append( sb, "Launches the Groovy Shell (aka. groovysh).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "args", 2 );
                append( sb, "Optional arguments to pass to the shell when executing.", 3 );
                append( sb, "Expression: ${args}", 3 );
                append( sb, "", 0 );

                append( sb, "color", 2 );
                append( sb, "Enable or disable use of ANSI colors (aka. groovysh --color). Normally auto-detected.", 3 );
                append( sb, "Expression: ${color}", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Enable debug output (aka. groovysh --debug).", 3 );
                append( sb, "Expression: ${debug}", 3 );
                append( sb, "", 0 );

                append( sb, "legacy (Default: false)", 2 );
                append( sb, "Enable the legacy shell.", 3 );
                append( sb, "Expression: ${legacy}", 3 );
                append( sb, "", 0 );

                append( sb, "providerSelection", 2 );
                append( sb, "A comma-separated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3 );
                append( sb, "Expression: ${gmaven.runtime}", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Suppress superfluous output (aka. groovysh --quiet).", 3 );
                append( sb, "Expression: ${quiet}", 3 );
                append( sb, "", 0 );

                append( sb, "terminal", 2 );
                append( sb, "Specify the terminal type to use (aka. groovysh --terminal). Normally auto-detected. Full class name or one of \'unix\', \'win\', \'windows\', \'false\', \'off\' or \'none\' expected.", 3 );
                append( sb, "Expression: ${terminal}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Enable verbose output (aka. groovysh --verbose).", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "testCompile".equals( goal ) )
        {
            append( sb, "groovy:testCompile", 0 );
            append( sb, "Compiles Groovy test sources.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classpath", 2 );
                append( sb, "Additional artifacts to add to the classpath (in addition to the classpath which is picked up from the executing poms configuration).", 3 );
                append( sb, "", 0 );

                append( sb, "debug (Default: false)", 2 );
                append( sb, "Turns debugging operation on or off.", 3 );
                append( sb, "Expression: ${debug}", 3 );
                append( sb, "", 0 );

                append( sb, "defaultScriptExtension (Default: .groovy)", 2 );
                append( sb, "Set the default extention for Groovy script source files.", 3 );
                append( sb, "Expression: ${defaultScriptExtension}", 3 );
                append( sb, "", 0 );

                append( sb, "invokeDynamic (Default: false)", 2 );
                append( sb, "Allow setting whether to support invokeDynamic (requires Java 7 or greater).", 3 );
                append( sb, "Expression: ${invokeDynamic}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.testOutputDirectory})", 2 );
                append( sb, "The directory where generated Java class files will be placed.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "providerSelection", 2 );
                append( sb, "A comma-separated list of provider keys, in order of preference of selection. If the invoking JVM is at least Java 1.5, then the Groovy 1.6 runtime will be used, else the Groovy 1.5 runtime is used.", 3 );
                append( sb, "Expression: ${gmaven.runtime}", 3 );
                append( sb, "", 0 );

                append( sb, "scriptBaseClassname", 2 );
                append( sb, "Sets the name of the base class for scripts. It must be a subclass of groovy.lang.Script.", 3 );
                append( sb, "Expression: ${scriptBaseClassname}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Flag to allow test compiliation to be skipped.", 3 );
                append( sb, "Expression: ${maven.test.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Sets the encoding to be used when reading source files.", 3 );
                append( sb, "Expression: ${sourceEncoding}", 3 );
                append( sb, "", 0 );

                append( sb, "sources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "stacktrace (Default: false)", 2 );
                append( sb, "Enable compiler to report stack trace information if a problem occurs.", 3 );
                append( sb, "Expression: ${stacktrace}", 3 );
                append( sb, "", 0 );

                append( sb, "targetBytecode", 2 );
                append( sb, "Allow setting the bytecode compatibility.", 3 );
                append( sb, "Expression: ${targetBytecode}", 3 );
                append( sb, "", 0 );

                append( sb, "testSources", 2 );
                append( sb, "Source files to be included. If not specified, then the default will be used.", 3 );
                append( sb, "", 0 );

                append( sb, "tolerance (Default: 0)", 2 );
                append( sb, "Sets the error tolerance, which is the number of non-fatal errors (per unit) that should be tolerated before compilation is aborted.", 3 );
                append( sb, "Expression: ${tolerance}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Turns verbose operation on or off.", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
