/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.adaptator.impl;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.IXMLParser;
import com.izforge.izpack.api.adaptator.XMLException;
import com.izforge.izpack.api.adaptator.impl.LineNumberFilter;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLParser
implements IXMLParser {
    private LineNumberFilter filter;
    private String parsedItem = null;

    public XMLParser() {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setXIncludeAware(true);
            XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
            this.filter = new LineNumberFilter(xmlReader);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(e);
        }
        catch (SAXException e) {
            throw new XMLException(e);
        }
    }

    private IXMLElement searchFirstElement(DOMResult domResult) {
        for (Node child = domResult.getNode().getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return new XMLElementImpl(child);
        }
        return null;
    }

    private DOMResult parseLineNrFromInputSource(InputSource inputSource) {
        DOMResult result = null;
        try {
            result = new DOMResult();
            SAXSource source = new SAXSource(inputSource);
            source.setXMLReader(this.filter);
            URL xslResourceUrl = IXMLParser.class.getResource("styleSheet.xsl");
            if (xslResourceUrl == null) {
                throw new XMLException("Can't find IzPack internal file \"styleSheet.xsl\"");
            }
            StreamSource xsltSource = new StreamSource(xslResourceUrl.openStream());
            Transformer xformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            xformer.transform(source, result);
            this.filter.applyLN(result);
        }
        catch (TransformerException e) {
            String extraInfos = null;
            if (this.parsedItem != null) {
                extraInfos = " in " + this.parsedItem;
            }
            if (e.getLocator() == null && this.filter.getDocumentLocator() != null) {
                Locator locator = this.filter.getDocumentLocator();
                extraInfos = extraInfos + " at line " + locator.getLineNumber() + ", column " + locator.getColumnNumber();
            }
            if (extraInfos != null) {
                throw new XMLException("Error" + extraInfos + " : " + e.getMessage(), e);
            }
            throw new XMLException(e);
        }
        catch (IOException e) {
            throw new XMLException(e);
        }
        finally {
            this.parsedItem = null;
        }
        return result;
    }

    @Override
    public IXMLElement parse(InputStream inputStream) {
        this.checkNotNullStream(inputStream);
        this.parsedItem = null;
        InputSource inputSource = new InputSource(inputStream);
        DOMResult result = this.parseLineNrFromInputSource(inputSource);
        return this.searchFirstElement(result);
    }

    @Override
    public IXMLElement parse(InputStream inputStream, String systemId) {
        this.checkNotNullStream(inputStream);
        this.parsedItem = systemId;
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(systemId);
        DOMResult result = this.parseLineNrFromInputSource(inputSource);
        return this.searchFirstElement(result);
    }

    @Override
    public IXMLElement parse(String inputString) {
        this.parsedItem = null;
        ByteBuffer buf = Charset.forName("UTF-8").encode(inputString);
        return this.parse(new ByteBufferInputStream(buf));
    }

    @Override
    public IXMLElement parse(URL inputURL) {
        this.parsedItem = inputURL.toString();
        InputSource inputSource = new InputSource(inputURL.toExternalForm());
        DOMResult domResult = this.parseLineNrFromInputSource(inputSource);
        return this.searchFirstElement(domResult);
    }

    private void checkNotNullStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("The input stream must be not null.");
        }
    }

    public class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer buf;

        public ByteBufferInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public synchronized int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            int c = this.buf.get() & 0xFF;
            return c;
        }

        @Override
        public synchronized int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }

        @Override
        public int available() throws IOException {
            return this.buf.remaining();
        }
    }
}

