/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.installer;

import com.izforge.izpack.api.data.InstallData;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public interface DataValidator {
    public static final String DATA_VALIDATOR_TAG = "validator";
    public static final String DATA_VALIDATOR_CLASSNAME_TAG = "classname";

    public Status validateData(InstallData var1);

    public String getErrorMessageId();

    public String getWarningMessageId();

    public boolean getDefaultAnswer();

    public static enum Status {
        OK("success"),
        WARNING("warning"),
        ERROR("error");

        private static Map<String, Status> lookup;
        private String attribute;

        private Status(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static Status getStatusFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, Status>();
            for (Status severity : EnumSet.allOf(Status.class)) {
                lookup.put(severity.getAttribute(), severity);
            }
        }
    }
}

