/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui.log;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.gui.log.LogError;
import com.izforge.izpack.gui.log.LogMessage;
import com.izforge.izpack.gui.log.LogWarning;
import java.io.File;
import java.io.FileWriter;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class Log
implements LogError,
LogWarning,
LogMessage {
    private static final String RESOURCE_PREFIX = "log.";
    private static final String DATE_FORMAT = "log.timeStamp";
    private static final String MESSAGE_PREFIX = "log.message_";
    private static final String WARNING_PREFIX = "log.warning_";
    private static final String ERROR_PREFIX = "log.error_";
    private static final String DEBUG_SWITCH = "IzPack.debug";
    private static final String CHANNEL_SPEC = "IzPack.debug.channel";
    private static final String CHANNEL_LIST = "IzPack.debug.dumpList";
    private static Log me = null;
    private String newline = System.getProperty("line.separator");
    private AutomatedInstallData installData = null;
    private ArrayList<Record> messages = new ArrayList();
    private ArrayList<Record> warnings = new ArrayList();
    private ArrayList<Record> errors = new ArrayList();
    private ArrayList<Record> debug = new ArrayList();
    private List<String> channels = null;
    private Map<String, String> recordedChannels = null;
    private boolean debugActive = false;
    private boolean dumpChannels = false;
    public static final String PANEL_TRACE = "PanelTrace";

    private Log() {
        this.installData = AutomatedInstallData.getInstance();
        String temp = System.getProperty(DEBUG_SWITCH);
        if (temp != null && temp.toUpperCase().equals("ON")) {
            this.debugActive = true;
        }
        if (this.debugActive) {
            this.recordedChannels = new HashMap<String, String>();
            this.channels = new ArrayList<String>();
            temp = System.getProperty(CHANNEL_LIST);
            if (temp != null && temp.toUpperCase().equals("ON")) {
                this.dumpChannels = true;
            }
            if ((temp = System.getProperty(CHANNEL_SPEC)) != null) {
                String[] channelList = temp.split(",");
                this.channels.addAll(Arrays.asList(channelList));
            }
        }
    }

    public static Log getInstance() {
        if (me == null) {
            me = new Log();
        }
        return me;
    }

    public void addMessage(int message, String[] detail) {
        if (message >= 0 && message < 0) {
            this.messages.add(new Record(message, detail));
        }
    }

    public void addCustomMessage(String template, String[] detail) {
        this.messages.add(new Record(template, detail));
    }

    public void addWarning(int message, String[] detail, Throwable exception) {
        if (message >= 1000 && message < 1000) {
            this.warnings.add(new Record(message, detail, exception));
        }
    }

    public void addCustomWarning(String template, String[] detail, Throwable exception) {
        this.warnings.add(new Record(template, detail, exception));
    }

    public void addError(int message, String[] detail, Throwable exception) {
        if (message >= 2000 && message < 2001) {
            this.errors.add(new Record(message, detail, exception));
            this.installData.setInstallSuccess(false);
        }
    }

    public void addCustomError(String template, String[] detail, Throwable exception) {
        this.errors.add(new Record(template, detail, exception));
    }

    public void addDebugMessage(String template, String[] detail, String channel, Throwable exception) {
        if (this.debugActive) {
            this.recordedChannels.put(channel, channel);
            if (channel == null || channel.length() == 0 || this.channels.contains(channel)) {
                Record record = new Record(template, detail, exception, channel);
                this.debug.add(record);
                System.out.println(this.buildDebug(record));
            }
        }
    }

    public boolean messagesRecorded() {
        return !this.messages.isEmpty();
    }

    public boolean warningsRecorded() {
        return !this.warnings.isEmpty();
    }

    public boolean errorsRecorded() {
        return !this.errors.isEmpty();
    }

    public void informUser() {
        String message = "";
        int messageType = 2;
        if (this.errorsRecorded()) {
            messageType = 0;
            message = this.installData.getLangpack().getString("log.informUserFail");
        } else if (this.warningsRecorded()) {
            messageType = 2;
            message = this.installData.getLangpack().getString("log.informUserPartial");
        } else {
            return;
        }
        int userChoice = JOptionPane.showConfirmDialog(null, message, this.installData.getLangpack().getString("log.informUserTitle"), 0, messageType);
        if (userChoice == 0) {
            this.writeReport();
        }
    }

    public void writeReport() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(this.installData.getLangpack().getString("log.saveLogTitle"));
        fileChooser.setSelectedFile(new File(this.installData.getLangpack().getString("log.LogFileName")));
        int choice = fileChooser.showSaveDialog(null);
        if (choice == 0) {
            this.writeReport(fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void writeReport(String file) {
        try {
            FileWriter writer = new FileWriter(file);
            String text = this.compileReport();
            writer.write(text, 0, text.length());
            writer.flush();
            writer.close();
        }
        catch (Throwable exception) {
            try {
                JOptionPane.showMessageDialog(null, this.installData.getLangpack().getString("log.reportWriteError", new String[]{file}), this.installData.getLangpack().getString("log.reportWriteErrorTitle"), 0);
            }
            catch (Throwable exception2) {
                exception2.printStackTrace();
            }
        }
    }

    private String compileReport() {
        int i;
        int count;
        StringBuffer report = new StringBuffer();
        String dateFormat = this.installData.getLangpack().getString(DATE_FORMAT);
        report.append("-------------------------------------------------------------------------------");
        report.append(this.newline);
        report.append(this.installData.getLangpack().getString("log.reportHeading"));
        report.append(this.newline);
        report.append("-------------------------------------------------------------------------------");
        report.append(this.newline);
        if (this.errorsRecorded()) {
            report.append(this.newline);
            report.append(this.installData.getLangpack().getString("log.installFailed"));
            report.append(this.newline);
        } else if (this.warningsRecorded()) {
            report.append(this.newline);
            report.append(this.installData.getLangpack().getString("log.partialInstall"));
            report.append(this.newline);
        }
        report.append(this.newline);
        report.append(this.installData.getLangpack().getString("log.messageCount", new String[]{Integer.toString(this.messages.size()), Integer.toString(this.warnings.size()), Integer.toString(this.errors.size())}));
        report.append(this.newline);
        report.append(this.newline);
        report.append(this.installData.getLangpack().getString("log.application", new String[]{this.installData.getInfo().getAppName(), this.installData.getInfo().getAppVersion()}));
        report.append(this.newline);
        report.append(this.installData.getLangpack().getString("log.timePrefix", new String[]{new SimpleDateFormat(dateFormat, new DateFormatSymbols()).format(new Date())}));
        report.append(this.newline);
        report.append(this.installData.getLangpack().getString("log.pathPrefix", new String[]{this.installData.getInstallPath()}));
        report.append(this.newline);
        if (this.messagesRecorded()) {
            report.append(this.newline);
            report.append(this.installData.getLangpack().getString("log.messageHeading"));
            report.append(this.newline);
            report.append(this.newline);
            count = this.messages.size();
            for (i = 0; i < count; ++i) {
                report.append(this.buildMessage(i));
            }
        }
        if (this.warningsRecorded()) {
            report.append(this.newline);
            report.append(this.installData.getLangpack().getString("log.warningHeading"));
            report.append(this.newline);
            report.append(this.newline);
            count = this.warnings.size();
            for (i = 0; i < count; ++i) {
                report.append(this.buildWarning(i));
            }
        }
        if (this.errorsRecorded()) {
            report.append(this.newline);
            report.append(this.installData.getLangpack().getString("log.errorHeading"));
            report.append(this.newline);
            report.append(this.newline);
            count = this.errors.size();
            for (i = 0; i < count; ++i) {
                report.append(this.buildError(i));
            }
        }
        if (this.debugActive) {
            report.append(this.newline);
            report.append(this.installData.getLangpack().getString("log.debugHeading"));
            report.append(this.newline);
            report.append(this.newline);
            count = this.errors.size();
            for (i = 0; i < count; ++i) {
                report.append(this.buildDebug(i));
            }
        }
        report.append("-------------------------------------------------------------------------------");
        report.append(this.newline);
        return report.toString();
    }

    private String buildMessage(int index) {
        Record record = this.messages.get(index);
        StringBuffer message = new StringBuffer();
        message.append(this.installData.getLangpack().getString("log.messagePrefix", new String[]{Integer.toString(index)}));
        if (record.message >= 0) {
            message.append(this.installData.getLangpack().getString(MESSAGE_PREFIX + Integer.toString(record.message), record.variables));
        } else {
            message.append(MessageFormat.format(record.template, record.variables));
        }
        message.append(this.newline);
        return message.toString();
    }

    private String buildWarning(int index) {
        Record record = this.warnings.get(index);
        StringBuffer message = new StringBuffer();
        message.append(this.installData.getLangpack().getString("log.warningPrefix", new String[]{Integer.toString(index)}));
        if (record.message >= 0) {
            message.append(this.installData.getLangpack().getString(WARNING_PREFIX + Integer.toString(record.message - 1000), record.variables));
        } else {
            message.append(MessageFormat.format(record.template, record.variables));
        }
        if (record.exception != null) {
            message.append(this.newline);
            message.append(this.installData.getLangpack().getString("log.exceptionPrefix", new String[]{record.exception.toString()}));
        }
        message.append(this.newline);
        return message.toString();
    }

    private String buildError(int index) {
        Record record = this.errors.get(index);
        StringBuffer message = new StringBuffer();
        message.append(this.installData.getLangpack().getString("log.errorPrefix", new String[]{Integer.toString(index)}));
        if (record.message >= 0) {
            message.append(this.installData.getLangpack().getString(ERROR_PREFIX + Integer.toString(record.message - 2000), record.variables));
        } else {
            message.append(MessageFormat.format(record.template, record.variables));
        }
        if (record.exception != null) {
            message.append(this.newline);
            message.append(this.installData.getLangpack().getString("log.exceptionPrefix", new String[]{record.exception.toString()}));
        }
        message.append(this.newline);
        return message.toString();
    }

    private String buildDebug(int index) {
        Record record = this.debug.get(index);
        return this.buildDebug(record);
    }

    private String buildDebug(Record record) {
        StringBuffer message = new StringBuffer();
        if (record.channel == null || record.channel.length() == 0) {
            message.append("Debug - general: ");
        } else {
            message.append("Debug - ").append(record.channel).append(": ");
        }
        message.append(MessageFormat.format(record.template, record.variables));
        if (record.exception != null) {
            message.append(this.newline);
            message.append(this.installData.getLangpack().getString("log.exceptionPrefix", new String[]{record.exception.toString()}));
        }
        message.append(this.newline);
        return message.toString();
    }

    public void dumpRecordedChannels() {
        if (this.debugActive && this.dumpChannels) {
            System.out.println();
            System.out.println("The following debug channels did record messages:");
            System.out.println();
            for (String channel : this.recordedChannels.keySet()) {
                System.out.println(" - " + channel);
            }
            System.out.println();
        }
    }

    private class Record {
        String channel;
        String template;
        int message;
        String[] variables;
        Throwable exception;

        Record(int message, String[] variables) {
            this.message = message;
            this.variables = variables;
        }

        Record(String template, String[] variables) {
            this.message = -1;
            this.template = template;
            this.variables = variables;
        }

        Record(int message, String[] variables, Throwable exception) {
            this.message = message;
            this.variables = variables;
            this.exception = exception;
        }

        Record(String template, String[] variables, Throwable exception) {
            this.message = -1;
            this.template = template;
            this.variables = variables;
            this.exception = exception;
        }

        Record(String template, String[] variables, Throwable exception, String channel) {
            this.message = -1;
            this.template = template;
            this.variables = variables;
            this.exception = exception;
            this.channel = channel;
        }
    }
}

