/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.automation;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.installer.automation.AutomatedPanelView;
import com.izforge.izpack.installer.automation.AutomatedPanels;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.PrivilegedRunner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class AutomatedInstaller
implements InstallerBase {
    private final AutomatedPanels panels;
    private final AutomatedInstallData installData;
    private RequirementsChecker requirements;
    private UninstallDataWriter uninstallDataWriter;
    private final Locales locales;
    private final Housekeeper housekeeper;

    public AutomatedInstaller(AutomatedPanels panels, AutomatedInstallData installData, Locales locales, RequirementsChecker requirements, UninstallDataWriter uninstallDataWriter, Housekeeper housekeeper) {
        this.panels = panels;
        this.installData = installData;
        this.locales = locales;
        this.requirements = requirements;
        this.uninstallDataWriter = uninstallDataWriter;
        this.housekeeper = housekeeper;
    }

    public void init(String inputFilename, String mediaPath, String[] args) throws Exception {
        PrivilegedRunner runner = new PrivilegedRunner(this.installData.getPlatform());
        if (!runner.hasCorrectPermissions(this.installData.getInfo(), this.installData.getRules())) {
            try {
                runner.relaunchWithElevatedRights(args);
            }
            catch (Exception e) {
                System.out.println(this.installData.getMessages().get("AutomatedInstaller.permissionError", new Object[0]));
            }
            System.exit(0);
        }
        File input = new File(inputFilename);
        IXMLElement installRecord = this.getXMLData(input);
        this.installData.setInstallationRecord(installRecord);
        String code = installRecord.getAttribute("langpack", "eng");
        this.locales.setLocale(code);
        this.installData.setMessages(this.locales.getMessages());
        this.installData.setLocale(this.locales.getLocale(), this.locales.getISOCode());
        this.installData.setMediaPath(mediaPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInstall() throws Exception {
        boolean reboot;
        boolean success = false;
        if (!this.requirements.check()) {
            System.out.println("[ Automated installation FAILED! ]");
            System.exit(-1);
            return;
        }
        System.out.println("[ Starting automated installation ]");
        try {
            List panelRoots = this.installData.getInstallationRecord().getChildren();
            for (IXMLElement panelRoot : panelRoots) {
                String panelId = panelRoot.getAttribute("id");
                for (AutomatedPanelView panelView : this.panels.getPanelViews()) {
                    if (!panelView.getPanelId().equals(panelId)) continue;
                    success = this.panels.switchPanel(panelView.getIndex(), true);
                    break;
                }
                if (success) continue;
                break;
            }
            if (success) {
                success = this.panels.isValid();
                if (this.uninstallDataWriter.isUninstallRequired()) {
                    success = this.uninstallDataWriter.write();
                }
            }
            if (success) {
                System.out.println("[ Automated installation done ]");
            } else {
                System.out.println("[ Automated installation FAILED! ]");
            }
            reboot = false;
        }
        catch (Exception e) {
            boolean reboot2;
            try {
                success = false;
                System.err.println(e.toString());
                e.printStackTrace();
                if (success) {
                    System.out.println("[ Automated installation done ]");
                } else {
                    System.out.println("[ Automated installation FAILED! ]");
                }
                reboot2 = false;
            }
            catch (Throwable throwable) {
                if (success) {
                    System.out.println("[ Automated installation done ]");
                } else {
                    System.out.println("[ Automated installation FAILED! ]");
                }
                boolean reboot3 = false;
                if (this.installData.isRebootNecessary()) {
                    System.out.println("[ There are file operations pending after reboot ]");
                    switch (this.installData.getInfo().getRebootAction()) {
                        case 3: {
                            reboot3 = true;
                        }
                    }
                    if (reboot3) {
                        System.out.println("[ Rebooting now automatically ]");
                    }
                }
                this.housekeeper.shutDown(success ? 0 : 1, reboot3);
                throw throwable;
            }
            if (this.installData.isRebootNecessary()) {
                System.out.println("[ There are file operations pending after reboot ]");
                switch (this.installData.getInfo().getRebootAction()) {
                    case 3: {
                        reboot2 = true;
                    }
                }
                if (reboot2) {
                    System.out.println("[ Rebooting now automatically ]");
                }
            }
            this.housekeeper.shutDown(success ? 0 : 1, reboot2);
        }
        if (this.installData.isRebootNecessary()) {
            System.out.println("[ There are file operations pending after reboot ]");
            switch (this.installData.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                }
            }
            if (reboot) {
                System.out.println("[ Rebooting now automatically ]");
            }
        }
        this.housekeeper.shutDown(success ? 0 : 1, reboot);
    }

    private IXMLElement getXMLData(File input) throws IOException {
        FileInputStream in = new FileInputStream(input);
        XMLParser parser = new XMLParser(false);
        IXMLElement rtn = parser.parse((InputStream)in, input.getAbsolutePath());
        in.close();
        return rtn;
    }

    @Override
    public void writeInstallationRecord(File file, UninstallData uninstallData) throws Exception {
        this.panels.writeInstallationRecord(file, uninstallData);
    }
}

