/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.bootstrap;

import com.izforge.izpack.installer.automation.AutomatedInstaller;
import com.izforge.izpack.installer.bootstrap.InstallerConsole;
import com.izforge.izpack.installer.bootstrap.InstallerGui;
import com.izforge.izpack.installer.container.impl.AutomatedInstallerContainer;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.StringTool;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Installer {
    private static int installerMode = 0;
    private static Logger logger;
    public static final int INSTALLER_GUI = 0;
    public static final int INSTALLER_AUTO = 1;
    public static final int INSTALLER_CONSOLE = 2;
    public static final int CONSOLE_INSTALL = 0;
    public static final int CONSOLE_GEN_TEMPLATE = 1;
    public static final int CONSOLE_FROM_TEMPLATE = 2;
    public static final int CONSOLE_FROM_SYSTEMPROPERTIES = 3;
    public static final int CONSOLE_FROM_SYSTEMPROPERTIESMERGE = 4;
    public static final String LOGGING_CONFIGURATION = "/com/izforge/izpack/installer/logging/logging.properties";

    public static void main(String[] args) {
        try {
            Installer.initializeLogging();
            Installer installer = new Installer();
            installer.start(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initializeLogging() {
        LogManager manager = LogManager.getLogManager();
        try {
            InputStream stream = Installer.class.getResourceAsStream(LOGGING_CONFIGURATION);
            if (stream != null) {
                manager.readConfiguration(stream);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        Logger rootLogger = Logger.getLogger("com.izforge.izpack");
        rootLogger.setUseParentHandlers(false);
        if (Debug.isDEBUG()) {
            rootLogger.setLevel(Level.FINE);
        } else {
            rootLogger.setLevel(Level.INFO);
        }
        logger = Logger.getLogger(Installer.class.getName());
        logger.info("Logging initialized at level '" + rootLogger.getLevel() + "'");
    }

    private void start(String[] args) {
        logger.info("Commandline arguments: " + StringTool.stringArrayToSpaceSeparatedString((String[])args));
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IzPack");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        try {
            Iterator<String> args_it = Arrays.asList(args).iterator();
            int type = 0;
            int consoleAction = 0;
            String path = null;
            String langcode = null;
            String media = null;
            while (args_it.hasNext()) {
                String arg = args_it.next().trim();
                try {
                    if ("-console".equalsIgnoreCase(arg)) {
                        type = 2;
                        continue;
                    }
                    if ("-options-template".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 1;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-options".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 2;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-options-system".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 3;
                        continue;
                    }
                    if ("-options-auto".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 4;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-language".equalsIgnoreCase(arg)) {
                        langcode = args_it.next().trim();
                        continue;
                    }
                    if ("-media".equalsIgnoreCase(arg)) {
                        media = args_it.next().trim();
                        continue;
                    }
                    type = 1;
                    path = arg;
                }
                catch (NoSuchElementException e) {
                    logger.log(Level.SEVERE, "Option \"" + arg + "\" requires an argument", e);
                    System.exit(1);
                }
            }
            this.launchInstall(type, consoleAction, path, langcode, media, args);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            System.exit(1);
        }
    }

    private void launchInstall(int type, int consoleAction, String path, String langCode, String mediaDir, String[] args) throws Exception {
        if (type == 0 && GraphicsEnvironment.isHeadless()) {
            type = 2;
        }
        installerMode = type;
        switch (type) {
            case 0: {
                InstallerGui.run(langCode, mediaDir);
                break;
            }
            case 1: {
                this.launchAutomatedInstaller(path, mediaDir, args);
                break;
            }
            case 2: {
                InstallerConsole.run(type, consoleAction, path, langCode, mediaDir, args);
            }
        }
    }

    private void launchAutomatedInstaller(String path, String mediaDir, String[] args) throws Exception {
        AutomatedInstallerContainer container = new AutomatedInstallerContainer();
        AutomatedInstaller automatedInstaller = (AutomatedInstaller)container.getComponent(AutomatedInstaller.class);
        automatedInstaller.init(path, mediaDir, args);
        automatedInstaller.doInstall();
    }

    public static int getInstallerMode() {
        return installerMode;
    }
}

