/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.core.handler.ConsolePrompt;
import com.izforge.izpack.core.handler.PromptUIHandler;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.AbstractPanelView;
import com.izforge.izpack.installer.util.PanelHelper;
import com.izforge.izpack.util.Console;

public class ConsolePanelView
extends AbstractPanelView<ConsolePanel> {
    private final Console console;
    private final ConsolePrompt prompt;

    public ConsolePanelView(Panel panel, ObjectFactory factory, InstallData installData, Console console) {
        super(panel, ConsolePanel.class, factory, installData);
        this.console = console;
        this.prompt = new ConsolePrompt(console, installData.getMessages());
    }

    public Class<ConsolePanel> getViewClass() {
        Panel panel = this.getPanel();
        return PanelHelper.getConsolePanel(panel.getClassName());
    }

    @Override
    protected ConsolePanel createView(Panel panel, Class<ConsolePanel> viewClass) {
        Class<ConsolePanel> impl = this.getViewClass();
        if (impl == null) {
            throw new IzPackException("Console implementation not found for panel: " + panel.getClassName());
        }
        return (ConsolePanel)this.getFactory().create(impl, new Object[]{panel, this});
    }

    @Override
    protected AbstractUIHandler getHandler() {
        return new PromptUIHandler((Prompt)this.prompt){

            public void emitNotification(String message) {
                ConsolePanelView.this.console.println(message);
            }
        };
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        ((ConsolePanel)this.getView()).createInstallationRecord(panelRoot);
    }
}

