/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.impl;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.gui.GUIPrompt;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.container.impl.InstallerContainer;
import com.izforge.izpack.installer.container.provider.GUIInstallDataProvider;
import com.izforge.izpack.installer.container.provider.IconsProvider;
import com.izforge.izpack.installer.container.provider.IzPanelsProvider;
import com.izforge.izpack.installer.gui.DefaultNavigator;
import com.izforge.izpack.installer.gui.InstallerController;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.SplashScreen;
import com.izforge.izpack.installer.language.LanguageDialog;
import com.izforge.izpack.installer.multiunpacker.MultiVolumeUnpackerHelper;
import com.izforge.izpack.installer.unpacker.GUIPackResources;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.injectors.Provider;
import org.picocontainer.injectors.ProviderAdapter;

public class GUIInstallerContainer
extends InstallerContainer {
    public GUIInstallerContainer() {
        this.initialise();
    }

    protected GUIInstallerContainer(MutablePicoContainer container) {
        this.initialise(container);
    }

    @Override
    protected void registerComponents(MutablePicoContainer pico) {
        super.registerComponents(pico);
        pico.addAdapter((ComponentAdapter)new ProviderAdapter((Provider)new GUIInstallDataProvider())).addAdapter((ComponentAdapter)new ProviderAdapter((Provider)new IzPanelsProvider())).addAdapter((ComponentAdapter)new ProviderAdapter((Provider)new IconsProvider()));
        pico.addComponent(GUIPrompt.class).addComponent(InstallerController.class).addComponent(DefaultNavigator.class).addComponent(InstallerFrame.class).addComponent(Log.class).addComponent(GUIPackResources.class).addComponent(MultiVolumeUnpackerHelper.class).addComponent(SplashScreen.class).as(new Properties[]{Characteristics.USE_NAMES}).addComponent(LanguageDialog.class);
    }

    @Override
    protected void resolveComponents(final MutablePicoContainer pico) {
        super.resolveComponents(pico);
        InstallData installdata = (InstallData)pico.getComponent(InstallData.class);
        pico.addConfig("title", (Object)this.getTitle(installdata));
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    InstallerFrame frame = (InstallerFrame)pico.getComponent(InstallerFrame.class);
                    IUnpacker unpacker = (IUnpacker)pico.getComponent(IUnpacker.class);
                    frame.setUnpacker(unpacker);
                }
            });
        }
        catch (Exception exception) {
            throw new IzPackException((Throwable)exception);
        }
    }

    private String getTitle(InstallData installData) {
        String key = "installer.reversetitle";
        Messages messages = installData.getMessages();
        String message = messages.get("installer.reversetitle", new Object[0]);
        message = message.equals("installer.reversetitle") ? messages.get("installer.title", new Object[0]) + " " + installData.getInfo().getAppName() : installData.getVariables().replace(message);
        return message;
    }
}

