/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.ResourceInterruptedException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.unpacker.AbstractPackResources;
import com.izforge.izpack.installer.web.WebRepositoryAccessor;
import com.izforge.izpack.util.IoHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;

public class GUIPackResources
extends AbstractPackResources {
    private static final String tempSubPath = "/IzpackWebTemp";

    public GUIPackResources(Resources resources, InstallData installData) {
        super(resources, installData);
    }

    @Override
    protected InputStream getWebPackStream(String name, String webDirURL) {
        InputStream result;
        String tempFile;
        InstallData installData = this.getInstallData();
        String baseName = installData.getInfo().getInstallerBase();
        String packURL = webDirURL + "/" + baseName + ".pack-" + name + ".jar";
        String tempFolder = IoHelper.translatePath((String)(installData.getInfo().getUninstallerPath() + tempSubPath), (Variables)installData.getVariables());
        try {
            tempFile = WebRepositoryAccessor.getCachedUrl(packURL, tempFolder);
        }
        catch (InterruptedIOException exception) {
            throw new ResourceInterruptedException("Retrieval of " + webDirURL + " interrupted", (Throwable)exception);
        }
        catch (IOException exception) {
            throw new ResourceException("Failed to read " + webDirURL, (Throwable)exception);
        }
        try {
            URL url = new URL("jar:" + tempFile + "!/packs/pack-" + name);
            result = url.openStream();
        }
        catch (IOException exception) {
            throw new ResourceException("Failed to read pack", (Throwable)exception);
        }
        return result;
    }
}

