/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.validator;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.gui.IzPanel;
import java.util.Set;
import java.util.logging.Logger;

public class ConditionValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(IzPanel.class.getName());
    private String lastFailedConditionId;

    public DataValidator.Status validateData(InstallData idata) {
        RulesEngine rules = idata.getRules();
        Set conditionIds = rules.getKnownConditionIds();
        for (String conditionId : conditionIds) {
            if (!conditionId.toLowerCase().startsWith(this.getClass().getSimpleName().toLowerCase() + ".") || rules.getCondition(conditionId).isTrue()) continue;
            logger.fine("Validation failed on condition: " + conditionId);
            this.lastFailedConditionId = conditionId;
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    public String getErrorMessageId() {
        return this.lastFailedConditionId + ".error.message";
    }

    public String getWarningMessageId() {
        return null;
    }

    public boolean getDefaultAnswer() {
        return false;
    }
}

