/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.unix.ShellScript;
import com.izforge.izpack.util.unix.UnixHelper;
import com.izforge.izpack.util.unix.UnixUser;
import com.izforge.izpack.util.unix.UnixUsers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Unix_Shortcut
extends Shortcut {
    private static final Logger logger = Logger.getLogger(Unix_Shortcut.class.getName());
    private static final String version = "$Id$";
    private static final String rev = "$Revision$";
    private static final String DESKTOP_EXT = ".desktop";
    private static final String N = "\n";
    private static final String H = "#";
    private static final String S = " ";
    private static final String C = "# ";
    private static ShellScript rootScript = null;
    private static ShellScript uninstallScript = null;
    private List<UnixUser> users;
    private String arguments;
    private String categories;
    private String description;
    private String encoding;
    private String iconLocation;
    private String kdeSubstituteUID;
    private String kdeUserName;
    private String linkName;
    private int linkType;
    private String mimeType;
    private String programGroup;
    private String targetPath;
    private String terminal;
    private String terminalOptions;
    private String type;
    private String url;
    private int userType;
    private String workingDirectory;
    private String createdDirectory;
    private String itsFileName;
    public ShellScript myInstallScript;
    public final String FS = File.separator;
    public final String myHome = System.getProperty("user.home");
    private String su;
    private String xdgDesktopIconCmd;
    private String myXdgDesktopIconCmd = null;
    private final Resources resources;
    private final InstallData installData;
    private String writtenFileName;

    public Unix_Shortcut(Resources resources, InstallData installData) {
        this.resources = resources;
        this.installData = installData;
        if (rootScript == null) {
            rootScript = new ShellScript();
        }
        if (uninstallScript == null) {
            uninstallScript = new ShellScript();
        }
        if (this.myInstallScript == null) {
            this.myInstallScript = new ShellScript();
        }
    }

    public String build() {
        StringBuffer result = new StringBuffer();
        String userLanguage = System.getProperty("user.language", "en");
        result.append("[Desktop Entry]\n");
        result.append("Categories=").append(this.categories).append(N);
        result.append("Comment=").append(this.description).append(N);
        result.append("Comment[").append(userLanguage).append("]=").append(this.description).append(N);
        result.append("Encoding=").append(this.encoding).append(N);
        if (!this.targetPath.isEmpty() || !this.arguments.isEmpty()) {
            result.append("Exec=");
            if (this.targetPath.contains(S)) {
                result.append("'").append(this.targetPath).append("'");
            } else {
                result.append(this.targetPath);
            }
            if (!this.arguments.isEmpty()) {
                result.append(S).append(this.arguments);
            }
            result.append(N);
        }
        result.append("GenericName=").append(N);
        result.append("GenericName[").append(userLanguage).append("]=").append(N);
        result.append("Icon=").append(this.iconLocation).append(N);
        result.append("MimeType=").append(this.mimeType).append(N);
        result.append("Name=").append(this.linkName).append(N);
        result.append("Name[").append(userLanguage).append("]=").append(this.linkName).append(N);
        result.append("Path=").append(this.workingDirectory).append(N);
        result.append("ServiceTypes=").append(N);
        result.append("SwallowExec=").append(N);
        result.append("SwallowTitle=").append(N);
        result.append("Terminal=").append(this.terminal).append(N);
        if (!(this.terminal.isEmpty() || this.terminal.equals("true") || this.terminal.equals("false"))) {
            logger.warning(String.format("Shortcut '%s' has terminal '%s' but should be 'true' or 'false'", this.linkName, this.terminal));
        }
        result.append("TerminalOptions=").append(this.terminalOptions).append(N);
        result.append("Type=").append(this.type).append(N);
        if (this.type.equalsIgnoreCase("Link") && this.url.isEmpty()) {
            logger.warning(String.format("Shortcut '%s' has type '%s' but URL is empty", this.linkName, this.type));
        }
        if (!this.url.isEmpty()) {
            result.append("URL=").append(this.url).append(N);
            if (!this.type.equalsIgnoreCase("Link")) {
                logger.warning(String.format("Shortcut '%s' has URL but type ('%s') is not 'Link'", this.linkName, this.type));
            }
        }
        result.append("X-KDE-SubstituteUID=").append(this.kdeSubstituteUID).append(N);
        result.append("X-KDE-Username=").append(this.kdeUserName).append(N);
        result.append(N);
        result.append("# created by ").append(this.getClass().getName()).append(S).append(rev).append(N);
        result.append(C).append(version);
        return result.toString();
    }

    @Override
    public void initialize(int aType, String aName) throws Exception {
        this.linkName = aName;
    }

    @Override
    public boolean supported() {
        return true;
    }

    @Override
    public String getDirectoryCreated() {
        return this.createdDirectory;
    }

    @Override
    public String getFileName() {
        return this.itsFileName;
    }

    @Override
    public List<String> getProgramGroups(int userType) {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("(Default)");
        File kdeShareApplnk = this.getKdeShareApplnkFolder(userType);
        try {
            File[] listing;
            for (File aListing : listing = kdeShareApplnk.listFiles()) {
                if (!aListing.isDirectory()) continue;
                groups.add(aListing.getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return groups;
    }

    @Override
    public String getProgramsFolder(int current_user) {
        String result = this.getKdeShareApplnkFolder(current_user).toString();
        return result;
    }

    private File getKdeShareApplnkFolder(int userType) {
        if (userType == 2) {
            return new File(File.separator + "usr" + File.separator + "share" + File.separator + "applications");
        }
        return new File(System.getProperty("user.home") + File.separator + ".local" + File.separator + "share" + File.separator + "applications");
    }

    private String makeFilenameScriptable(String filename) {
        return filename.replace(S, "\\ ");
    }

    @Override
    public boolean multipleUsers() {
        return true;
    }

    @Override
    public void save() throws Exception {
        Object target = null;
        String shortCutDef = this.build();
        boolean rootUser4All = this.getUserType() == 2;
        boolean create4All = this.getCreateForAll();
        if ("".equals(this.programGroup) && this.getLinkType() == 3) {
            this.itsFileName = target;
            File shortCutLocation = null;
            String ApplicationShortcutPathName = this.installData.getVariable("ApplicationShortcutPath");
            if (null != ApplicationShortcutPathName && !ApplicationShortcutPathName.equals("")) {
                File ApplicationShortcutPath = new File(ApplicationShortcutPathName);
                if (ApplicationShortcutPath.isAbsolute()) {
                    if (!ApplicationShortcutPath.exists() && ApplicationShortcutPath.mkdirs() && ApplicationShortcutPath.canWrite()) {
                        shortCutLocation = ApplicationShortcutPath;
                    }
                    if (ApplicationShortcutPath.exists() && ApplicationShortcutPath.isDirectory() && ApplicationShortcutPath.canWrite()) {
                        shortCutLocation = ApplicationShortcutPath;
                    }
                } else {
                    File relativePath = new File(this.installData.getInstallPath() + this.FS + ApplicationShortcutPath);
                    relativePath.mkdirs();
                    shortCutLocation = new File(relativePath.toString());
                }
            }
            if (shortCutLocation == null) {
                shortCutLocation = new File(this.installData.getInstallPath());
            }
            File writtenDesktopFile = this.writeAppShortcutWithOutSpace(shortCutLocation.toString(), this.linkName, shortCutDef);
            this.uninstaller.addFile(writtenDesktopFile.toString(), true);
            String cmd = this.getXdgDesktopIconCmd();
            if (cmd != null) {
                this.createExtXdgDesktopIconCmd(shortCutLocation);
                this.myInstallScript.appendln(new String[]{this.makeFilenameScriptable(this.myXdgDesktopIconCmd), "install", "--novendor", StringTool.escapeSpaces((String)writtenDesktopFile.toString())});
                ShellScript myUninstallScript = new ShellScript();
                myUninstallScript.appendln(new String[]{this.makeFilenameScriptable(this.myXdgDesktopIconCmd), "uninstall", "--novendor", StringTool.escapeSpaces((String)writtenDesktopFile.toString())});
                this.uninstaller.addUninstallScript(myUninstallScript.getContentAsString());
            } else {
                File myDesktopFile;
                while ((myDesktopFile = new File(this.myHome + this.FS + "Desktop" + writtenDesktopFile.getName() + "-" + System.currentTimeMillis() + DESKTOP_EXT)).exists()) {
                }
                Unix_Shortcut.copyTo(writtenDesktopFile, myDesktopFile);
                this.uninstaller.addFile(myDesktopFile.toString(), true);
            }
            if (rootUser4All && create4All) {
                if (cmd != null) {
                    this.installDesktopFileToAllUsersDesktop(writtenDesktopFile);
                } else {
                    this.copyDesktopFileToAllUsersDesktop(writtenDesktopFile);
                }
            }
        } else if (rootUser4All && create4All) {
            File theIcon = new File(this.getIconLocation());
            File commonIcon = new File("/usr/share/pixmaps/" + theIcon.getName());
            try {
                Unix_Shortcut.copyTo(theIcon, commonIcon);
                this.uninstaller.addFile(commonIcon.toString(), true);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not copy " + theIcon + " to " + commonIcon + " (" + e.getMessage() + ")", e);
            }
            this.itsFileName = target;
            File writtenFile = this.writeAppShortcut("/usr/share/applications/", this.linkName, shortCutDef);
            this.setWrittenFileName(writtenFile.getName());
            this.uninstaller.addFile(writtenFile.toString(), true);
        } else {
            String localApps = this.myHome + "/.local/share/applications/";
            String localPixmaps = this.myHome + "/.local/share/pixmaps/";
            try {
                File file = new File(localApps);
                file.mkdirs();
                file = new File(localPixmaps);
                file.mkdirs();
            }
            catch (Exception ignore) {
                logger.warning("Failed creating " + localApps + " or " + localPixmaps);
            }
            File theIcon = new File(this.getIconLocation());
            File commonIcon = new File(localPixmaps + theIcon.getName());
            try {
                Unix_Shortcut.copyTo(theIcon, commonIcon);
                this.uninstaller.addFile(commonIcon.toString(), true);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not copy " + theIcon + " to " + commonIcon + " (" + e.getMessage() + ")", e);
            }
            this.itsFileName = target;
            File writtenFile = this.writeAppShortcut(localApps, this.linkName, shortCutDef);
            this.setWrittenFileName(writtenFile.getName());
            this.uninstaller.addFile(writtenFile.toString(), true);
        }
    }

    public void createExtXdgDesktopIconCmd(File shortCutLocation) throws IOException, ResourceNotFoundException {
        ShellScript myXdgDesktopIconScript = new ShellScript(null);
        String lines = this.resources.getString("/com/izforge/izpack/util/unix/xdgdesktopiconscript.sh", null);
        myXdgDesktopIconScript.append((Object)lines);
        this.myXdgDesktopIconCmd = shortCutLocation + this.FS + "IzPackLocaleEnabledXdgDesktopIconScript.sh";
        myXdgDesktopIconScript.write(this.myXdgDesktopIconCmd);
        FileExecutor.getExecOutput((String[])new String[]{UnixHelper.getCustomCommand((String)"chmod"), "+x", this.myXdgDesktopIconCmd}, (boolean)true);
    }

    private void installDesktopFileToAllUsersDesktop(File writtenDesktopFile) {
        for (UnixUser user : this.getUsers()) {
            if (user.getHome().equals(this.myHome)) {
                logger.info("Skipping self-copy: " + user.getHome() + " == " + this.myHome);
                continue;
            }
            try {
                rootScript.append(new String[]{this.getSuCommand(), user.getName(), "-c"});
                rootScript.appendln(new String[]{"\"" + this.myXdgDesktopIconCmd, "install", "--novendor", StringTool.escapeSpaces((String)writtenDesktopFile.toString()) + "\""});
                uninstallScript.append(new String[]{this.getSuCommand(), user.getName(), "-c"});
                uninstallScript.appendln(new String[]{"\"" + this.myXdgDesktopIconCmd, "uninstall", "--novendor", StringTool.escapeSpaces((String)writtenDesktopFile.toString()) + "\""});
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        logger.fine("==============================");
        logger.fine(rootScript.getContentAsString());
    }

    private String getSuCommand() {
        if (this.su == null) {
            this.su = UnixHelper.getSuCommand();
        }
        return this.su;
    }

    private String getXdgDesktopIconCmd() {
        if (this.xdgDesktopIconCmd == null) {
            this.xdgDesktopIconCmd = UnixHelper.getCustomCommand((String)"xdg-desktop-icon");
        }
        return this.xdgDesktopIconCmd;
    }

    private List<UnixUser> getUsers() {
        if (this.users == null) {
            this.users = UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops();
        }
        return this.users;
    }

    private void copyDesktopFileToAllUsersDesktop(File writtenDesktopFile) throws IOException {
        String chmod = UnixHelper.getCustomCommand((String)"chmod");
        String chown = UnixHelper.getCustomCommand((String)"chown");
        String rm = UnixHelper.getRmCommand();
        String copy = UnixHelper.getCpCommand();
        File tempFile = File.createTempFile(this.getClass().getName(), Long.toString(System.currentTimeMillis()) + ".tmp");
        Unix_Shortcut.copyTo(writtenDesktopFile, tempFile);
        FileExecutor.getExecOutput((String[])new String[]{chmod, "uga+rwx", tempFile.toString()});
        for (UnixUser user : this.getUsers()) {
            if (user.getHome().equals(this.myHome)) {
                logger.info("Skipping self-copy: " + user.getHome() + " == " + this.myHome);
                continue;
            }
            try {
                File dest = new File(user.getHome() + this.FS + "Desktop" + this.FS + writtenDesktopFile.getName());
                rootScript.append((Object)this.getSuCommand());
                rootScript.append((Object)S);
                rootScript.append((Object)user.getName());
                rootScript.append((Object)S);
                rootScript.append((Object)"-c");
                rootScript.append((Object)S);
                rootScript.append('\"');
                rootScript.append((Object)copy);
                rootScript.append((Object)S);
                rootScript.append((Object)tempFile.toString());
                rootScript.append((Object)S);
                rootScript.append((Object)StringTool.replace((String)dest.toString(), (String)S, (String)"\\ "));
                rootScript.appendln('\"');
                rootScript.append('\n');
                rootScript.append((Object)chown);
                rootScript.append((Object)S);
                rootScript.append((Object)user.getName());
                rootScript.append((Object)S);
                rootScript.appendln((Object)StringTool.replace((String)dest.toString(), (String)S, (String)"\\ "));
                rootScript.append('\n');
                rootScript.append('\n');
                uninstallScript.append((Object)this.getSuCommand());
                uninstallScript.append((Object)S);
                uninstallScript.append((Object)user.getName());
                uninstallScript.append((Object)S);
                uninstallScript.append((Object)"-c");
                uninstallScript.append((Object)S);
                uninstallScript.append('\"');
                uninstallScript.append((Object)rm);
                uninstallScript.append((Object)S);
                uninstallScript.append((Object)StringTool.replace((String)dest.toString(), (String)S, (String)"\\ "));
                uninstallScript.appendln('\"');
                uninstallScript.appendln();
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Could not copy as root: " + e.getMessage(), e);
            }
        }
        rootScript.append((Object)rm);
        rootScript.append((Object)S);
        rootScript.appendln((Object)tempFile.toString());
        rootScript.appendln();
    }

    @Override
    public void execPostAction() {
        String scriptFilename;
        logger.fine("Launching post execution action");
        String pseudoUnique = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        try {
            scriptFilename = File.createTempFile(pseudoUnique, ".sh").toString();
        }
        catch (IOException e) {
            scriptFilename = System.getProperty("java.io.tmpdir", "/tmp") + "/" + pseudoUnique + ".sh";
            e.printStackTrace();
        }
        rootScript.write(scriptFilename);
        rootScript.exec();
        rootScript.delete();
        logger.fine(rootScript.toString());
        pseudoUnique = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        try {
            scriptFilename = File.createTempFile(pseudoUnique, ".sh").toString();
        }
        catch (IOException e) {
            scriptFilename = System.getProperty("java.io.tmpdir", "/tmp") + "/" + pseudoUnique + ".sh";
            e.printStackTrace();
        }
        this.myInstallScript.write(scriptFilename);
        this.myInstallScript.exec();
        this.myInstallScript.delete();
        logger.fine(this.myInstallScript.toString());
        logger.fine(uninstallScript.toString());
        this.uninstaller.addUninstallScript(uninstallScript.getContentAsString());
    }

    public static void copyTo(File inFile, File outFile) throws IOException {
        int readBytes;
        char[] cbuff = new char[32768];
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        while ((readBytes = reader.read(cbuff, 0, cbuff.length)) != -1) {
            writer.write(cbuff, 0, readBytes);
        }
        reader.close();
        writer.close();
    }

    public String getWrittenFileName() {
        return this.writtenFileName;
    }

    protected void setWrittenFileName(String s) {
        this.writtenFileName = s;
    }

    private File writeAppShortcut(String targetPath, String shortcutName, String shortcutDef) {
        return this.writeAppShortcutWithSimpleSpacehandling(targetPath, shortcutName, shortcutDef, false);
    }

    private File writeAppShortcutWithOutSpace(String targetPath, String shortcutName, String shortcutDef) {
        return this.writeAppShortcutWithSimpleSpacehandling(targetPath, shortcutName, shortcutDef, true);
    }

    private File writeAppShortcutWithSimpleSpacehandling(String targetPath, String shortcutName, String shortcutDef, boolean replaceSpacesWithMinus) {
        File shortcutFile;
        if (!targetPath.endsWith("/") && !targetPath.endsWith("\\")) {
            targetPath = targetPath + File.separatorChar;
        }
        while ((shortcutFile = new File(targetPath + (replaceSpacesWithMinus ? StringTool.replaceSpacesWithMinus((String)shortcutName) : shortcutName) + "-" + System.currentTimeMillis() + DESKTOP_EXT)).exists()) {
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(shortcutFile);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        try {
            if (fileWriter != null) {
                fileWriter.write(shortcutDef);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return shortcutFile;
    }

    @Override
    public void setArguments(String args) {
        this.arguments = args;
    }

    @Override
    public void setCategories(String theCategories) {
        this.categories = theCategories;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setEncoding(String aEncoding) {
        this.encoding = aEncoding;
    }

    @Override
    public void setKdeSubstUID(String trueFalseOrNothing) {
        this.kdeSubstituteUID = trueFalseOrNothing;
    }

    @Override
    public void setKdeUserName(String aUserName) {
        this.kdeUserName = aUserName;
    }

    @Override
    public void setIconLocation(String path, int index) {
        this.iconLocation = path;
    }

    @Override
    public String getIconLocation() {
        return this.iconLocation;
    }

    @Override
    public void setLinkName(String aName) {
        this.linkName = aName;
    }

    @Override
    public void setLinkType(int aType) throws IllegalArgumentException, UnsupportedEncodingException {
        this.linkType = aType;
    }

    @Override
    public int getLinkType() {
        return this.linkType;
    }

    @Override
    public void setMimetype(String aMimeType) {
        this.mimeType = aMimeType;
    }

    @Override
    public void setProgramGroup(String aGroupName) {
        this.programGroup = aGroupName;
    }

    @Override
    public void setShowCommand(int show) {
    }

    @Override
    public void setTargetPath(String aPath) {
        this.targetPath = aPath;
    }

    @Override
    public void setUserType(int aUserType) {
        this.userType = aUserType;
    }

    @Override
    public int getUserType() {
        return this.userType;
    }

    @Override
    public void setWorkingDirectory(String aDirectory) {
        this.workingDirectory = aDirectory;
    }

    @Override
    public void setTerminal(String trueFalseOrNothing) {
        this.terminal = trueFalseOrNothing;
    }

    @Override
    public void setTerminalOptions(String someTerminalOptions) {
        this.terminalOptions = someTerminalOptions;
    }

    @Override
    public void setTryExec(String aTryExec) {
    }

    @Override
    public void setType(String aType) {
        this.type = aType;
    }

    @Override
    public void setURL(String anUrl) {
        this.url = anUrl;
    }

    public String toString() {
        return this.linkName + N + this.build();
    }
}

