/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.coi.tools.os.izpack.Registry;
import com.coi.tools.os.win.RegDataContainer;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.util.Librarian;
import java.util.List;
import java.util.Properties;

public class Win_RegistryHandler
extends RegistryHandler {
    private final Librarian librarian;
    private Registry registry;

    public Win_RegistryHandler(Librarian librarian) {
        this.librarian = librarian;
    }

    public void setValue(String key, String value, String contents) throws NativeLibException {
        Object ob;
        if (contents.contains("OLD_KEY_VALUE") && this.getRegistry().valueExist(key, value) && (ob = this.getRegistry().getValueAsObject(key, value)) instanceof String) {
            Properties props = new Properties();
            props.put("OLD_KEY_VALUE", ob);
            VariableSubstitutorImpl variableSubstitutor = new VariableSubstitutorImpl(props);
            try {
                contents = variableSubstitutor.substitute(contents);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.getRegistry().setValue(key, value, contents);
    }

    public void setValue(String key, String value, String[] contents) throws NativeLibException {
        this.getRegistry().setValue(key, value, contents);
    }

    public void setValue(String key, String value, byte[] contents) throws NativeLibException {
        this.getRegistry().setValue(key, value, contents);
    }

    public void setValue(String key, String value, long contents) throws NativeLibException {
        this.getRegistry().setValue(key, value, contents);
    }

    public RegDataContainer getValue(String key, String value, RegDataContainer defaultVal) throws NativeLibException {
        if (this.valueExist(key, value)) {
            return this.getValue(key, value);
        }
        return defaultVal;
    }

    public boolean keyExist(String key) throws NativeLibException {
        return this.getRegistry().keyExist(key);
    }

    public boolean valueExist(String key, String value) throws NativeLibException {
        return this.getRegistry().valueExist(key, value);
    }

    public String[] getSubkeys(String key) throws NativeLibException {
        return this.getRegistry().getSubkeys(key);
    }

    public String[] getValueNames(String key) throws NativeLibException {
        return this.getRegistry().getValueNames(key);
    }

    public RegDataContainer getValue(String key, String value) throws NativeLibException {
        return this.getRegistry().getValue(key, value);
    }

    public void createKey(String key) throws NativeLibException {
        this.getRegistry().createKey(key);
    }

    public void deleteKey(String key) throws NativeLibException {
        this.getRegistry().deleteKey(key);
    }

    public void deleteKeyIfEmpty(String key) throws NativeLibException {
        this.getRegistry().deleteKeyIfEmpty(key);
    }

    public void deleteValue(String key, String value) throws NativeLibException {
        this.getRegistry().deleteValue(key, value);
    }

    public void setRoot(int i) throws NativeLibException {
        this.getRegistry().setRoot(i);
    }

    public int getRoot() throws NativeLibException {
        return this.getRegistry().getRoot();
    }

    public void setLogPrevSetValueFlag(boolean flagVal) throws NativeLibException {
        this.getRegistry().setLogPrevSetValueFlag(flagVal);
    }

    public boolean getLogPrevSetValueFlag() throws NativeLibException {
        return this.getRegistry().getLogPrevSetValueFlag();
    }

    public void activateLogging() throws NativeLibException {
        this.getRegistry().activateLogging();
    }

    public void suspendLogging() throws NativeLibException {
        this.getRegistry().suspendLogging();
    }

    public void resetLogging() throws NativeLibException {
        this.getRegistry().resetLogging();
    }

    public List<Object> getLoggingInfo() throws NativeLibException {
        return this.getRegistry().getLoggingInfo();
    }

    public void setLoggingInfo(List info) throws NativeLibException {
        this.getRegistry().setLoggingInfo(info);
    }

    public void addLoggingInfo(List info) throws NativeLibException {
        this.getRegistry().addLoggingInfo(info);
    }

    public void rewind() throws NativeLibException {
        this.getRegistry().rewind();
    }

    private synchronized Registry getRegistry() throws NativeLibException {
        if (this.registry == null) {
            try {
                this.registry = new Registry(this.librarian);
            }
            catch (Throwable exception) {
                throw new NativeLibException("Failed to create Registry: " + exception.getMessage(), exception);
            }
        }
        return this.registry;
    }
}

