/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.requirement;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.installer.RequirementChecker;
import com.izforge.izpack.util.FileUtil;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LockFileChecker
implements RequirementChecker {
    private final InstallData installData;
    private final Prompt prompt;
    private static final Logger logger = Logger.getLogger(LockFileChecker.class.getName());

    public LockFileChecker(AutomatedInstallData installData, Prompt prompt) {
        this.installData = installData;
        this.prompt = prompt;
    }

    public boolean check() {
        boolean result = true;
        Info installationInfo = this.installData.getInfo();
        if (installationInfo.isSingleInstance() && !Boolean.getBoolean("MULTIINSTANCE")) {
            String appName = installationInfo.getAppName();
            File file = FileUtil.getLockFile((String)appName);
            if (file.exists()) {
                result = this.handleLockFile(file);
            } else {
                try {
                    if (file.createNewFile()) {
                        logger.fine("Created lock file:" + file.getPath());
                        file.deleteOnExit();
                    } else {
                        logger.warning("Failed to create lock file: " + file.getPath());
                        logger.warning("*** Multiple instances of installer will be allowed ***");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Lock file could not be created: " + e.getMessage(), e);
                    logger.warning("*** Multiple instances of installer will be allowed ***");
                }
                result = true;
            }
        }
        return result;
    }

    protected boolean handleLockFile(File file) {
        boolean result = true;
        logger.fine("Lock File Exists, asking user for permission to proceed.");
        StringBuilder msg = new StringBuilder();
        String appName = this.installData.getInfo().getAppName();
        msg.append("The " + appName + " installer you are attempting to run seems to have a copy already running.\n\n");
        msg.append("This could be from a previous failed installation attempt or you may have accidentally launched\n");
        msg.append("the installer twice. The recommended action is to select 'No' and wait for the other copy of\n");
        msg.append("the installer to start. If you are sure there is no other copy of the installer running, click\n");
        msg.append("the 'Yes' button to allow this installer to run.\n\n");
        msg.append("Are you sure you want to continue with this installation?");
        Prompt.Option selected = this.prompt.confirm(Prompt.Type.WARNING, msg.toString(), Prompt.Options.YES_NO);
        if (selected == Prompt.Option.YES) {
            logger.fine("Setting temp file to delete on continue");
            file.deleteOnExit();
        } else {
            logger.fine("Leaving temp file alone and exiting");
            result = false;
        }
        return result;
    }
}

