/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.util.HashMap;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.deser.EnumResolver;
import org.codehaus.jackson.map.deser.StdKeyDeserializer;
import org.codehaus.jackson.map.type.JavaType;
import org.codehaus.jackson.map.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StdKeyDeserializers {
    final HashMap<JavaType, KeyDeserializer> _keyDeserializers = new HashMap();

    private StdKeyDeserializers() {
        this.add(new StdKeyDeserializer.BoolKD());
        this.add(new StdKeyDeserializer.ByteKD());
        this.add(new StdKeyDeserializer.CharKD());
        this.add(new StdKeyDeserializer.ShortKD());
        this.add(new StdKeyDeserializer.IntKD());
        this.add(new StdKeyDeserializer.LongKD());
        this.add(new StdKeyDeserializer.FloatKD());
        this.add(new StdKeyDeserializer.DoubleKD());
    }

    public static HashMap<JavaType, KeyDeserializer> constructAll() {
        return new StdKeyDeserializers()._keyDeserializers;
    }

    public static KeyDeserializer constructEnumKeyDeserializer(JavaType type) {
        EnumResolver er = EnumResolver.constructFor(type.getRawClass());
        return new StdKeyDeserializer.EnumKD(er);
    }

    void add(StdKeyDeserializer kdeser) {
        Class<?> keyClass = kdeser.getKeyClass();
        this._keyDeserializers.put(TypeFactory.instance.fromClass(keyClass), kdeser);
    }
}

