/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.node;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonNode;
import org.codehaus.jackson.map.node.ContainerNode;
import org.codehaus.jackson.map.node.MissingNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayNode
extends ContainerNode {
    ArrayList<JsonNode> mChildren;

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int size() {
        return this.mChildren == null ? 0 : this.mChildren.size();
    }

    @Override
    public JsonNode getElementValue(int index) {
        if (index >= 0 && this.mChildren != null && index < this.mChildren.size()) {
            return this.mChildren.get(index);
        }
        return null;
    }

    @Override
    public JsonNode getFieldValue(String fieldName) {
        return null;
    }

    @Override
    public Iterator<JsonNode> getElements() {
        return this.mChildren == null ? ContainerNode.NoNodesIterator.instance() : this.mChildren.iterator();
    }

    @Override
    public JsonNode getPath(String fieldName) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode getPath(int index) {
        if (index >= 0 && this.mChildren != null && index < this.mChildren.size()) {
            return this.mChildren.get(index);
        }
        return MissingNode.getInstance();
    }

    @Override
    public void appendElement(JsonNode node) {
        if (this.mChildren == null) {
            this.mChildren = new ArrayList();
        }
        this.mChildren.add(node);
    }

    @Override
    public void insertElement(int index, JsonNode value) {
        if (this.mChildren == null) {
            this.mChildren = new ArrayList();
            this.mChildren.add(value);
            return;
        }
        if (index < 0) {
            this.mChildren.add(0, value);
        } else if (index >= this.mChildren.size()) {
            this.mChildren.add(value);
        } else {
            this.mChildren.add(index, value);
        }
    }

    @Override
    public JsonNode removeElement(int index) {
        if (index >= 0 && this.mChildren != null && index < this.mChildren.size()) {
            return this.mChildren.remove(index);
        }
        return null;
    }

    @Override
    public JsonNode removeElement(String fieldName) {
        throw this._constructNoObjectMods();
    }

    @Override
    public JsonNode setElement(int index, JsonNode value) {
        if (this.mChildren == null || index < 0 || index >= this.mChildren.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + index + ", array size " + this.size());
        }
        return this.mChildren.set(index, value);
    }

    @Override
    public JsonNode setElement(String fieldName, JsonNode value) {
        throw this._constructNoObjectMods();
    }

    @Override
    public void writeTo(JsonGenerator jg) throws IOException, JsonGenerationException {
        jg.writeStartArray();
        if (this.mChildren != null) {
            for (JsonNode n : this.mChildren) {
                n.writeTo(jg);
            }
        }
        jg.writeEndArray();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ArrayNode other = (ArrayNode)o;
        if (this.mChildren == null) {
            return other.mChildren == null;
        }
        return other.sameChildren(this.mChildren);
    }

    public int hashCode() {
        int hash;
        if (this.mChildren == null) {
            hash = 1;
        } else {
            hash = this.mChildren.size();
            for (JsonNode n : this.mChildren) {
                if (n == null) continue;
                hash ^= n.hashCode();
            }
        }
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16 + (this.size() << 4));
        sb.append('[');
        if (this.mChildren != null) {
            int len = this.mChildren.size();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.mChildren.get(i).toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    private boolean sameChildren(ArrayList<JsonNode> otherChildren) {
        int len = otherChildren.size();
        if (this.mChildren.size() != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.mChildren.get(i).equals(otherChildren.get(i))) continue;
            return false;
        }
        return true;
    }
}

