/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompiler
extends AbstractLogEnabled
implements Compiler {
    protected static final String EOL = System.getProperty("line.separator");
    protected static final String PS = System.getProperty("path.separator");
    private CompilerOutputStyle compilerOutputStyle;
    private String inputFileEnding;
    private String outputFileEnding;
    private String outputFile;

    protected AbstractCompiler(CompilerOutputStyle compilerOutputStyle, String inputFileEnding, String outputFileEnding, String outputFile) {
        this.compilerOutputStyle = compilerOutputStyle;
        this.inputFileEnding = inputFileEnding;
        this.outputFileEnding = outputFileEnding;
        this.outputFile = outputFile;
    }

    @Override
    public CompilerOutputStyle getCompilerOutputStyle() {
        return this.compilerOutputStyle;
    }

    @Override
    public String getInputFileEnding(CompilerConfiguration configuration) throws CompilerException {
        return this.inputFileEnding;
    }

    @Override
    public String getOutputFileEnding(CompilerConfiguration configuration) throws CompilerException {
        if (this.compilerOutputStyle != CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE) {
            throw new RuntimeException("This compiler implementation doesn't have one output file per input file.");
        }
        return this.outputFileEnding;
    }

    @Override
    public String getOutputFile(CompilerConfiguration configuration) throws CompilerException {
        if (this.compilerOutputStyle != CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) {
            throw new RuntimeException("This compiler implementation doesn't have one output file for all files.");
        }
        return this.outputFile;
    }

    @Override
    public boolean canUpdateTarget(CompilerConfiguration configuration) throws CompilerException {
        return true;
    }

    public static String getPathString(List<String> pathElements) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = pathElements.iterator();
        while (it.hasNext()) {
            sb.append((Object)it.next()).append(File.pathSeparator);
        }
        return sb.toString();
    }

    protected static Set<String> getSourceFilesForSourceRoot(CompilerConfiguration config, String sourceLocation) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceLocation);
        Set<String> includes = config.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            String[] inclStrs = includes.toArray(new String[includes.size()]);
            scanner.setIncludes(inclStrs);
        } else {
            scanner.setIncludes(new String[]{"**/*.java"});
        }
        Set<String> excludes = config.getExcludes();
        if (excludes != null && !excludes.isEmpty()) {
            String[] exclStrs = excludes.toArray(new String[excludes.size()]);
            scanner.setIncludes(exclStrs);
        }
        scanner.scan();
        String[] sourceDirectorySources = scanner.getIncludedFiles();
        HashSet<String> sources = new HashSet<String>();
        for (int j = 0; j < sourceDirectorySources.length; ++j) {
            File f = new File(sourceLocation, sourceDirectorySources[j]);
            sources.add(f.getPath());
        }
        return sources;
    }

    protected static String[] getSourceFiles(CompilerConfiguration config) {
        HashSet<String> sources = new HashSet<String>();
        Set<File> sourceFiles = config.getSourceFiles();
        if (sourceFiles != null && !sourceFiles.isEmpty()) {
            for (File sourceFile : sourceFiles) {
                sources.add(sourceFile.getAbsolutePath());
            }
        } else {
            for (String sourceLocation : config.getSourceLocations()) {
                sources.addAll(AbstractCompiler.getSourceFilesForSourceRoot(config, sourceLocation));
            }
        }
        String[] result = sources.isEmpty() ? new String[]{} : sources.toArray(new String[sources.size()]);
        return result;
    }

    protected static String makeClassName(String fileName, String sourceDir) throws CompilerException {
        File origFile = new File(fileName);
        String canonical = null;
        if (origFile.exists()) {
            canonical = AbstractCompiler.getCanonicalPath(origFile).replace('\\', '/');
        }
        if (sourceDir != null) {
            String prefix = AbstractCompiler.getCanonicalPath(new File(sourceDir)).replace('\\', '/');
            if (canonical != null) {
                if (canonical.startsWith(prefix)) {
                    String result = canonical.substring(prefix.length() + 1, canonical.length() - 5);
                    result = result.replace('/', '.');
                    return result;
                }
            } else {
                File t = new File(sourceDir, fileName);
                if (t.exists()) {
                    String str = AbstractCompiler.getCanonicalPath(t).replace('\\', '/');
                    return str.substring(prefix.length() + 1, str.length() - 5).replace('/', '.');
                }
            }
        }
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        fileName = fileName.replace('\\', '.');
        return fileName.replace('/', '.');
    }

    private static String getCanonicalPath(File origFile) throws CompilerException {
        try {
            return origFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CompilerException("Error while getting the canonical path of '" + origFile.getAbsolutePath() + "'.", e);
        }
    }

    protected static String[] toStringArray(List arguments) {
        String[] args = new String[arguments.size()];
        int argLength = arguments.size();
        for (int i = 0; i < argLength; ++i) {
            args[i] = (String)arguments.get(i);
        }
        return args;
    }
}

