/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

public class CompilerMessage {
    private static final String JDK_6_NOTE_PREFIX = "note: ";
    private static final String JDK_6_WARNING_PREFIX = "warning: ";
    private final Kind kind;
    private int startline;
    private int startcolumn;
    private int endline;
    private int endcolumn;
    private String file;
    private final String message;

    @Deprecated
    public CompilerMessage(String file, boolean error, int startline, int startcolumn, int endline, int endcolumn, String message) {
        this.file = file;
        this.kind = error ? Kind.ERROR : Kind.WARNING;
        this.startline = startline;
        this.startcolumn = startcolumn;
        this.endline = endline;
        this.endcolumn = endcolumn;
        this.message = this.cleanupMessage(message);
    }

    public CompilerMessage(String file, Kind kind, int startline, int startcolumn, int endline, int endcolumn, String message) {
        this.file = file;
        this.kind = kind;
        this.startline = startline;
        this.startcolumn = startcolumn;
        this.endline = endline;
        this.endcolumn = endcolumn;
        this.message = this.cleanupMessage(message);
    }

    @Deprecated
    public CompilerMessage(String message) {
        this.kind = Kind.WARNING;
        this.message = this.cleanupMessage(message);
    }

    @Deprecated
    public CompilerMessage(String message, boolean error) {
        this.kind = error ? Kind.ERROR : Kind.WARNING;
        this.message = this.cleanupMessage(message);
    }

    public CompilerMessage(String message, Kind kind) {
        this.kind = kind;
        this.message = this.cleanupMessage(message);
    }

    public String getFile() {
        return this.file;
    }

    public boolean isError() {
        return this.kind == Kind.ERROR;
    }

    public int getStartLine() {
        return this.startline;
    }

    public int getStartColumn() {
        return this.startcolumn;
    }

    public int getEndLine() {
        return this.endline;
    }

    public int getEndColumn() {
        return this.endcolumn;
    }

    public String getMessage() {
        return this.message;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String toString() {
        if (this.file != null) {
            if (this.startline != 0) {
                if (this.startcolumn != 0) {
                    return this.file + ":[" + this.startline + "," + this.startcolumn + "] " + this.message;
                }
                return this.file + ":[" + this.startline + "] " + this.message;
            }
            return this.file + ": " + this.message;
        }
        return this.message;
    }

    private String cleanupMessage(String msg) {
        if (this.kind == Kind.NOTE && msg.toLowerCase().startsWith(JDK_6_NOTE_PREFIX)) {
            msg = msg.substring(JDK_6_NOTE_PREFIX.length());
        } else if ((this.kind == Kind.WARNING || this.kind == Kind.MANDATORY_WARNING) && msg.toLowerCase().startsWith(JDK_6_WARNING_PREFIX)) {
            msg = msg.substring(JDK_6_WARNING_PREFIX.length());
        }
        return msg;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        ERROR("error"),
        MANDATORY_WARNING("mandatory_warning"),
        NOTE("note"),
        OTHER("other"),
        WARNING("warning");

        private String type;

        private Kind(String type) {
            this.type = type;
        }
    }
}

