/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoURLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusIoZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection {
    public static final String ROLE_HINT = "zipFile";
    public static final String JAR_ROLE_HINT = "jarFile";

    @Override
    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The zip file has not been set.");
        }
        URL url = new URL("jar:" + f.toURI().toURL() + "!/");
        ZipFile zipFile = new ZipFile(f);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        return new ZipFileResourceIterator(en, url, zipFile);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipFileResourceIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        private final Enumeration en;
        private final URL url;
        private final ZipFile zipFile;

        public ZipFileResourceIterator(Enumeration en, URL url, ZipFile zipFile) {
            this.en = en;
            this.url = url;
            this.zipFile = zipFile;
        }

        @Override
        public boolean hasNext() {
            return this.en.hasMoreElements();
        }

        @Override
        public PlexusIoResource next() {
            final ZipEntry entry = (ZipEntry)this.en.nextElement();
            PlexusIoURLResource res = new PlexusIoURLResource(){

                public URL getURL() throws IOException {
                    String spec = entry.getName();
                    if (spec.startsWith("/")) {
                        spec = "./" + spec;
                    }
                    return new URL(ZipFileResourceIterator.this.url, spec);
                }

                protected String getDescriptionForError() {
                    return "" + ZipFileResourceIterator.this.url + "" + entry.getName();
                }
            };
            boolean dir = entry.isDirectory();
            res.setName(entry.getName());
            res.setDirectory(dir);
            res.setExisting(true);
            res.setFile(!dir);
            long l = entry.getTime();
            res.setLastModified(l == -1L ? 0L : l);
            res.setSize(dir ? -1L : entry.getSize());
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing isn't implemented.");
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }
    }
}

