/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public class Java7Reflector {
    public static final Method pathMethod;
    public static final Method readAttributes;
    public static final Class posixFileAttributes;
    private static final Object[] arr;
    private static final Method ownerMethod;
    private static final Method groupMethod;
    private static final Method permissionsMethod;
    private static final Method userPrincipalGetNameMethod;
    private static Method posixFilePermissionsToStringMethod;
    private static final boolean isJava7;

    public static Object getPosixFileAttributes(File file) throws IOException {
        Object path = Java7Reflector.invoke(pathMethod, file, new Object[0]);
        return Java7Reflector.invoke(readAttributes, null, path, posixFileAttributes, arr);
    }

    public static String getOwnerUserName(Object posixFileAttributes) {
        Object invoke = Java7Reflector.invoke(ownerMethod, posixFileAttributes, new Object[0]);
        return (String)Java7Reflector.invoke(userPrincipalGetNameMethod, invoke, new Object[0]);
    }

    public static String getOwnerGroupName(Object posixFileAttributes) {
        Object invoke = Java7Reflector.invoke(groupMethod, posixFileAttributes, new Object[0]);
        return (String)Java7Reflector.invoke(userPrincipalGetNameMethod, invoke, new Object[0]);
    }

    public static String getPermissions(Object posixFileAttributes) {
        Set permissions = (Set)Java7Reflector.invoke(permissionsMethod, posixFileAttributes, new Object[0]);
        return (String)Java7Reflector.invoke(posixFilePermissionsToStringMethod, posixFileAttributes, permissions);
    }

    private static Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isJava7() {
        return isJava7;
    }

    static {
        boolean isJava7x = true;
        Method posixFilePermisssionsMethod = null;
        Method userPrincipalGetNameMethodLocal = null;
        Method readAttributesLocal = null;
        Class<?> posixFileAttributesLocal = null;
        Method ownerMethodLocal = null;
        Method groupMethodLocal = null;
        Method permissionsMethodLocal = null;
        Object[] arrLocal = null;
        Method pathMethodLocal = null;
        try {
            Class<?> files = Class.forName("java.nio.file.Files");
            Class<?> path = Class.forName("java.nio.file.Path");
            Class<?> linkOption = Class.forName("java.nio.file.LinkOption");
            Class<?> userPrincipal = Class.forName("java.nio.file.attribute.UserPrincipal");
            Class<?> posixFilePermisssions = Class.forName("java.nio.file.attribute.PosixFilePermissions");
            posixFileAttributesLocal = Class.forName("java.nio.file.attribute.PosixFileAttributes");
            pathMethodLocal = File.class.getMethod("toPath", new Class[0]);
            posixFilePermisssionsMethod = posixFilePermisssions.getMethod("toString", Set.class);
            userPrincipalGetNameMethodLocal = userPrincipal.getMethod("getName", new Class[0]);
            ?[] enumConstants = linkOption.getEnumConstants();
            Enum NOFOLLOW_LINKS = (Enum)enumConstants[0];
            arrLocal = (Object[])Array.newInstance(linkOption, 1);
            arrLocal[0] = NOFOLLOW_LINKS;
            Class[] params = new Class[]{path, Class.class, arrLocal.getClass()};
            readAttributesLocal = files.getMethod("readAttributes", params);
            ownerMethodLocal = posixFileAttributesLocal.getMethod("owner", new Class[0]);
            groupMethodLocal = posixFileAttributesLocal.getMethod("group", new Class[0]);
            permissionsMethodLocal = posixFileAttributesLocal.getMethod("permissions", new Class[0]);
        }
        catch (Exception e) {
            isJava7x = false;
        }
        isJava7 = isJava7x;
        posixFilePermissionsToStringMethod = posixFilePermisssionsMethod;
        userPrincipalGetNameMethod = userPrincipalGetNameMethodLocal;
        readAttributes = readAttributesLocal;
        posixFileAttributes = posixFileAttributesLocal;
        ownerMethod = ownerMethodLocal;
        groupMethod = groupMethodLocal;
        permissionsMethod = permissionsMethodLocal;
        arr = arrLocal;
        pathMethod = pathMethodLocal;
    }
}

