/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.parameters;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.summit.parameters.ParameterConverter;

public class BaseParameterConverter
implements ParameterConverter {
    protected Map parameters;
    protected String characterEncoding = "US-ASCII";

    public BaseParameterConverter(Map parameters) {
        this(parameters, null);
    }

    public BaseParameterConverter(Map parameters, String characterEncoding) {
        if (parameters == null) {
            throw new NullPointerException("parameter map is null");
        }
        if (characterEncoding != null) {
            this.characterEncoding = characterEncoding;
        }
        this.parameters = parameters;
    }

    public Map getParametersMap() {
        return this.parameters;
    }

    public boolean containsKey(Object key) {
        return this.parameters.containsKey(key);
    }

    public Iterator keys() {
        return this.parameters.keySet().iterator();
    }

    public Object[] getKeys() {
        return this.parameters.keySet().toArray();
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        boolean value = defaultValue;
        Object object = this.parameters.get(name);
        if (object != null) {
            String tmp = this.getString(name);
            if (tmp.equalsIgnoreCase("1") || tmp.equalsIgnoreCase("true") || tmp.equalsIgnoreCase("on")) {
                value = true;
            }
            if (tmp.equalsIgnoreCase("0") || tmp.equalsIgnoreCase("false") || tmp.equalsIgnoreCase("off")) {
                value = false;
            }
        }
        return value;
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public Boolean getBool(String name, boolean defaultValue) {
        return new Boolean(this.getBoolean(name, defaultValue));
    }

    public Boolean getBool(String name) {
        return new Boolean(this.getBoolean(name, false));
    }

    public double getDouble(String name, double defaultValue) {
        double value = defaultValue;
        try {
            Object object = this.parameters.get(name);
            if (object != null) {
                value = Double.valueOf(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public float getFloat(String name, float defaultValue) {
        float value = defaultValue;
        try {
            Object object = this.parameters.get(name);
            if (object != null) {
                value = Float.valueOf(((String[])object)[0]).floatValue();
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        BigDecimal value = defaultValue;
        try {
            String temp;
            Object object = this.parameters.get(name);
            if (object != null && (temp = ((String[])object)[0]).length() > 0) {
                value = new BigDecimal(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, new BigDecimal(0.0));
    }

    public BigDecimal[] getBigDecimals(String name) {
        BigDecimal[] value = null;
        String[] object = this.getStrings(name);
        if (object != null) {
            String[] temp = object;
            value = new BigDecimal[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                value[i] = new BigDecimal(temp[i]);
            }
        }
        return value;
    }

    public int getInt(String name, int defaultValue) {
        int value = defaultValue;
        try {
            Object object = this.parameters.get(name);
            if (object != null) {
                value = Integer.valueOf(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public Integer getInteger(String name, int defaultValue) {
        return new Integer(this.getInt(name, defaultValue));
    }

    public Integer getInteger(String name, Integer def) {
        return new Integer(this.getInt(name, def));
    }

    public Integer getInteger(String name) {
        return new Integer(this.getInt(name, 0));
    }

    public int[] getInts(String name) {
        int[] value = null;
        String[] object = this.getStrings(name);
        if (object != null) {
            String[] temp = object;
            value = new int[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                value[i] = Integer.parseInt(temp[i]);
            }
        }
        return value;
    }

    public Integer[] getIntegers(String name) {
        Integer[] value = null;
        String[] object = this.getStrings(name);
        if (object != null) {
            String[] temp = object;
            value = new Integer[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                value[i] = Integer.valueOf(temp[i]);
            }
        }
        return value;
    }

    public long getLong(String name, long defaultValue) {
        long value = defaultValue;
        try {
            Object object = this.parameters.get(name);
            if (object != null) {
                value = Long.valueOf(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public long[] getLongs(String name) {
        long[] value = null;
        String[] object = this.getStrings(name);
        if (object != null) {
            String[] temp = object;
            value = new long[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                value[i] = Long.parseLong(temp[i]);
            }
        }
        return value;
    }

    public Long[] getLongObjects(String name) {
        Long[] value = null;
        String[] object = this.getStrings(name);
        if (object != null) {
            String[] temp = object;
            value = new Long[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                value[i] = Long.valueOf(temp[i]);
            }
        }
        return value;
    }

    public byte getByte(String name, byte defaultValue) {
        byte value = defaultValue;
        try {
            Object object = this.parameters.get(name);
            if (object != null) {
                value = Byte.valueOf(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    public byte[] getBytes(String name) throws UnsupportedEncodingException {
        String tempStr = this.getString(name);
        if (tempStr != null) {
            return tempStr.getBytes(this.characterEncoding);
        }
        return null;
    }

    public String getString(String name) {
        try {
            String value = null;
            Object object = this.parameters.get(name);
            if (object != null) {
                value = ((String[])object)[0];
            }
            if (value == null || value.equals("null")) {
                return null;
            }
            return value;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public String get(String name) {
        return this.getString(name);
    }

    public String getString(String name, String defaultValue) {
        String value = this.getString(name);
        if (value == null || value.length() == 0 || value.equals("null")) {
            return defaultValue;
        }
        return value;
    }

    public String[] getStrings(String name) {
        String[] value = null;
        Object object = this.parameters.get(name);
        if (object != null) {
            value = (String[])object;
        }
        return value;
    }

    public String[] getStrings(String name, String[] defaultValue) {
        String[] value = this.getStrings(name);
        if (value == null || value.length == 0) {
            return defaultValue;
        }
        return value;
    }

    public Object getObject(String name) {
        try {
            Object value = null;
            Object object = this.parameters.get(name);
            if (object != null) {
                value = ((Object[])object)[0];
            }
            return value;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Object[] getObjects(String name) {
        try {
            return (Object[])this.parameters.get(name);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Date getDate(String name, DateFormat df, Date defaultValue) {
        Date date = null;
        if (this.containsKey(name)) {
            try {
                df.setLenient(false);
                date = df.parse(this.getString(name));
            }
            catch (ParseException e) {
                date = defaultValue;
            }
        } else {
            date = defaultValue;
        }
        return date;
    }

    public Date getDate(String name, DateFormat df) {
        return this.getDate(name, df, null);
    }

    public Date getDate(String name) {
        DateFormat df = DateFormat.getDateInstance();
        return this.getDate(name, df, null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.parameters.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            sb.append('{');
            sb.append(name);
            sb.append('=');
            String[] values = (String[])this.parameters.get(name);
            if (values == null) {
                sb.append("null");
            } else if (values.length == 1) {
                sb.append(values[0]);
            } else {
                for (int j = 0; j < values.length; ++j) {
                    if (j != 0) {
                        sb.append(", ");
                    }
                    sb.append('[');
                    sb.append(values[j]);
                    sb.append(']');
                }
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

